// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    public partial class ScopingQuestion : IUtf8JsonSerializable, IJsonModel<ScopingQuestion>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ScopingQuestion>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ScopingQuestion>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScopingQuestion>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScopingQuestion)} does not support writing '{format}' format.");
            }

            if (options.Format != "W")
            {
                writer.WritePropertyName("questionId"u8);
                writer.WriteStringValue(QuestionId);
            }
            if (options.Format != "W" && Optional.IsDefined(SuperiorQuestionId))
            {
                writer.WritePropertyName("superiorQuestionId"u8);
                writer.WriteStringValue(SuperiorQuestionId);
            }
            if (options.Format != "W")
            {
                writer.WritePropertyName("inputType"u8);
                writer.WriteStringValue(InputType.ToString());
            }
            if (options.Format != "W")
            {
                writer.WritePropertyName("optionIds"u8);
                writer.WriteStartArray();
                foreach (var item in OptionIds)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W")
            {
                writer.WritePropertyName("rules"u8);
                writer.WriteStartArray();
                foreach (var item in Rules)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ShowSubQuestionsValue))
            {
                writer.WritePropertyName("showSubQuestionsValue"u8);
                writer.WriteStringValue(ShowSubQuestionsValue);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ScopingQuestion IJsonModel<ScopingQuestion>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScopingQuestion>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ScopingQuestion)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeScopingQuestion(document.RootElement, options);
        }

        internal static ScopingQuestion DeserializeScopingQuestion(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string questionId = default;
            string superiorQuestionId = default;
            ScopingQuestionInputType inputType = default;
            IReadOnlyList<string> optionIds = default;
            IReadOnlyList<QuestionRuleItem> rules = default;
            string showSubQuestionsValue = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("questionId"u8))
                {
                    questionId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("superiorQuestionId"u8))
                {
                    superiorQuestionId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("inputType"u8))
                {
                    inputType = new ScopingQuestionInputType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("optionIds"u8))
                {
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    optionIds = array;
                    continue;
                }
                if (property.NameEquals("rules"u8))
                {
                    List<QuestionRuleItem> array = new List<QuestionRuleItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new QuestionRuleItem(item.GetString()));
                    }
                    rules = array;
                    continue;
                }
                if (property.NameEquals("showSubQuestionsValue"u8))
                {
                    showSubQuestionsValue = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ScopingQuestion(
                questionId,
                superiorQuestionId,
                inputType,
                optionIds,
                rules,
                showSubQuestionsValue,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ScopingQuestion>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScopingQuestion>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ScopingQuestion)} does not support writing '{options.Format}' format.");
            }
        }

        ScopingQuestion IPersistableModel<ScopingQuestion>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ScopingQuestion>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeScopingQuestion(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ScopingQuestion)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ScopingQuestion>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
