// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> Scoping answer. </summary>
    public partial class ScopingAnswer
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ScopingAnswer"/>. </summary>
        /// <param name="questionId"> Question id. </param>
        /// <param name="answers"> Question answer value list. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="questionId"/> or <paramref name="answers"/> is null. </exception>
        public ScopingAnswer(string questionId, IEnumerable<string> answers)
        {
            Argument.AssertNotNull(questionId, nameof(questionId));
            Argument.AssertNotNull(answers, nameof(answers));

            QuestionId = questionId;
            Answers = answers.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ScopingAnswer"/>. </summary>
        /// <param name="questionId"> Question id. </param>
        /// <param name="answers"> Question answer value list. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ScopingAnswer(string questionId, IList<string> answers, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            QuestionId = questionId;
            Answers = answers;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ScopingAnswer"/> for deserialization. </summary>
        internal ScopingAnswer()
        {
        }

        /// <summary> Question id. </summary>
        public string QuestionId { get; set; }
        /// <summary> Question answer value list. </summary>
        public IList<string> Answers { get; }
    }
}
