// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> Indicates the customer responsibility type. </summary>
    public readonly partial struct ResponsibilityType : IEquatable<ResponsibilityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResponsibilityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResponsibilityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutomatedValue = "Automated";
        private const string ScopedManualValue = "ScopedManual";
        private const string ManualValue = "Manual";

        /// <summary> The responsibility is automated. </summary>
        public static ResponsibilityType Automated { get; } = new ResponsibilityType(AutomatedValue);
        /// <summary> The responsibility is scoped manual. </summary>
        public static ResponsibilityType ScopedManual { get; } = new ResponsibilityType(ScopedManualValue);
        /// <summary> The responsibility is manual. </summary>
        public static ResponsibilityType Manual { get; } = new ResponsibilityType(ManualValue);
        /// <summary> Determines if two <see cref="ResponsibilityType"/> values are the same. </summary>
        public static bool operator ==(ResponsibilityType left, ResponsibilityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResponsibilityType"/> values are not the same. </summary>
        public static bool operator !=(ResponsibilityType left, ResponsibilityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResponsibilityType"/>. </summary>
        public static implicit operator ResponsibilityType(string value) => new ResponsibilityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResponsibilityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResponsibilityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
