// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> Indicates the customer responsibility severity. </summary>
    public readonly partial struct ResponsibilitySeverity : IEquatable<ResponsibilitySeverity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResponsibilitySeverity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResponsibilitySeverity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HighValue = "High";
        private const string MediumValue = "Medium";
        private const string LowValue = "Low";

        /// <summary> The responsibility is high severity. </summary>
        public static ResponsibilitySeverity High { get; } = new ResponsibilitySeverity(HighValue);
        /// <summary> The responsibility is medium severity. </summary>
        public static ResponsibilitySeverity Medium { get; } = new ResponsibilitySeverity(MediumValue);
        /// <summary> The responsibility is low severity. </summary>
        public static ResponsibilitySeverity Low { get; } = new ResponsibilitySeverity(LowValue);
        /// <summary> Determines if two <see cref="ResponsibilitySeverity"/> values are the same. </summary>
        public static bool operator ==(ResponsibilitySeverity left, ResponsibilitySeverity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResponsibilitySeverity"/> values are not the same. </summary>
        public static bool operator !=(ResponsibilitySeverity left, ResponsibilitySeverity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResponsibilitySeverity"/>. </summary>
        public static implicit operator ResponsibilitySeverity(string value) => new ResponsibilitySeverity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResponsibilitySeverity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResponsibilitySeverity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
