// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> Indicates the customer responsibility supported cloud environment. </summary>
    public readonly partial struct ResponsibilityEnvironment : IEquatable<ResponsibilityEnvironment>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResponsibilityEnvironment"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResponsibilityEnvironment(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureValue = "Azure";
        private const string AwsValue = "AWS";
        private const string GcpValue = "GCP";
        private const string GeneralValue = "General";

        /// <summary> The responsibility is supported in Azure. </summary>
        public static ResponsibilityEnvironment Azure { get; } = new ResponsibilityEnvironment(AzureValue);
        /// <summary> The responsibility is supported in AWS. </summary>
        public static ResponsibilityEnvironment Aws { get; } = new ResponsibilityEnvironment(AwsValue);
        /// <summary> The responsibility is supported in GCP. </summary>
        public static ResponsibilityEnvironment Gcp { get; } = new ResponsibilityEnvironment(GcpValue);
        /// <summary> The responsibility is general requirement of all environment. </summary>
        public static ResponsibilityEnvironment General { get; } = new ResponsibilityEnvironment(GeneralValue);
        /// <summary> Determines if two <see cref="ResponsibilityEnvironment"/> values are the same. </summary>
        public static bool operator ==(ResponsibilityEnvironment left, ResponsibilityEnvironment right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResponsibilityEnvironment"/> values are not the same. </summary>
        public static bool operator !=(ResponsibilityEnvironment left, ResponsibilityEnvironment right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResponsibilityEnvironment"/>. </summary>
        public static implicit operator ResponsibilityEnvironment(string value) => new ResponsibilityEnvironment(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResponsibilityEnvironment other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResponsibilityEnvironment other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
