// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> Indicates whether the fix action is Succeeded or Failed. </summary>
    public readonly partial struct ReportResult : IEquatable<ReportResult>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReportResult"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReportResult(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";

        /// <summary> The result is succeeded. </summary>
        public static ReportResult Succeeded { get; } = new ReportResult(SucceededValue);
        /// <summary> The result is failed. </summary>
        public static ReportResult Failed { get; } = new ReportResult(FailedValue);
        /// <summary> Determines if two <see cref="ReportResult"/> values are the same. </summary>
        public static bool operator ==(ReportResult left, ReportResult right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReportResult"/> values are not the same. </summary>
        public static bool operator !=(ReportResult left, ReportResult right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReportResult"/>. </summary>
        public static implicit operator ReportResult(string value) => new ReportResult(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReportResult other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReportResult other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
