// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> Indicates the resource status. </summary>
    public readonly partial struct ReportResourceStatus : IEquatable<ReportResourceStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReportResourceStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReportResourceStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HealthyValue = "Healthy";
        private const string UnhealthyValue = "Unhealthy";

        /// <summary> The resource is healthy. </summary>
        public static ReportResourceStatus Healthy { get; } = new ReportResourceStatus(HealthyValue);
        /// <summary> The resource is unhealthy. </summary>
        public static ReportResourceStatus Unhealthy { get; } = new ReportResourceStatus(UnhealthyValue);
        /// <summary> Determines if two <see cref="ReportResourceStatus"/> values are the same. </summary>
        public static bool operator ==(ReportResourceStatus left, ReportResourceStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReportResourceStatus"/> values are not the same. </summary>
        public static bool operator !=(ReportResourceStatus left, ReportResourceStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReportResourceStatus"/>. </summary>
        public static implicit operator ReportResourceStatus(string value) => new ReportResourceStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReportResourceStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReportResourceStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
