// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> Resource Origin. </summary>
    public readonly partial struct ReportResourceOrigin : IEquatable<ReportResourceOrigin>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReportResourceOrigin"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReportResourceOrigin(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureValue = "Azure";
        private const string AwsValue = "AWS";
        private const string GcpValue = "GCP";

        /// <summary> The resource is from Azure. </summary>
        public static ReportResourceOrigin Azure { get; } = new ReportResourceOrigin(AzureValue);
        /// <summary> The resource is from AWS. </summary>
        public static ReportResourceOrigin Aws { get; } = new ReportResourceOrigin(AwsValue);
        /// <summary> The resource is from GCP. </summary>
        public static ReportResourceOrigin Gcp { get; } = new ReportResourceOrigin(GcpValue);
        /// <summary> Determines if two <see cref="ReportResourceOrigin"/> values are the same. </summary>
        public static bool operator ==(ReportResourceOrigin left, ReportResourceOrigin right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReportResourceOrigin"/> values are not the same. </summary>
        public static bool operator !=(ReportResourceOrigin left, ReportResourceOrigin right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReportResourceOrigin"/>. </summary>
        public static implicit operator ReportResourceOrigin(string value) => new ReportResourceOrigin(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReportResourceOrigin other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReportResourceOrigin other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
