// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    public partial class ReportOverviewStatus : IUtf8JsonSerializable, IJsonModel<ReportOverviewStatus>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ReportOverviewStatus>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ReportOverviewStatus>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ReportOverviewStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ReportOverviewStatus)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(PassedCount))
            {
                writer.WritePropertyName("passedCount"u8);
                writer.WriteNumberValue(PassedCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(FailedCount))
            {
                writer.WritePropertyName("failedCount"u8);
                writer.WriteNumberValue(FailedCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ManualCount))
            {
                writer.WritePropertyName("manualCount"u8);
                writer.WriteNumberValue(ManualCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(NotApplicableCount))
            {
                writer.WritePropertyName("notApplicableCount"u8);
                writer.WriteNumberValue(NotApplicableCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(PendingCount))
            {
                writer.WritePropertyName("pendingCount"u8);
                writer.WriteNumberValue(PendingCount.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ReportOverviewStatus IJsonModel<ReportOverviewStatus>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ReportOverviewStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ReportOverviewStatus)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeReportOverviewStatus(document.RootElement, options);
        }

        internal static ReportOverviewStatus DeserializeReportOverviewStatus(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? passedCount = default;
            int? failedCount = default;
            int? manualCount = default;
            int? notApplicableCount = default;
            int? pendingCount = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("passedCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    passedCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("failedCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    failedCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("manualCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    manualCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("notApplicableCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    notApplicableCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("pendingCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pendingCount = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ReportOverviewStatus(
                passedCount,
                failedCount,
                manualCount,
                notApplicableCount,
                pendingCount,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ReportOverviewStatus>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ReportOverviewStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ReportOverviewStatus)} does not support writing '{options.Format}' format.");
            }
        }

        ReportOverviewStatus IPersistableModel<ReportOverviewStatus>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ReportOverviewStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeReportOverviewStatus(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ReportOverviewStatus)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ReportOverviewStatus>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
