// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> Parameters for listing in use storage accounts operation. If subscription list is null, it will check the user's all subscriptions. </summary>
    public partial class ReportListInUseStorageAccountsContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ReportListInUseStorageAccountsContent"/>. </summary>
        public ReportListInUseStorageAccountsContent()
        {
            SubscriptionIds = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ReportListInUseStorageAccountsContent"/>. </summary>
        /// <param name="subscriptionIds"> List of subscription ids to be query. If the list is null or empty, the API will query all the subscriptions of the user. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ReportListInUseStorageAccountsContent(IList<string> subscriptionIds, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SubscriptionIds = subscriptionIds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of subscription ids to be query. If the list is null or empty, the API will query all the subscriptions of the user. </summary>
        public IList<string> SubscriptionIds { get; }
    }
}
