// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> A class represent the recommendation solution. </summary>
    public partial class RecommendationSolution
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RecommendationSolution"/>. </summary>
        internal RecommendationSolution()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RecommendationSolution"/>. </summary>
        /// <param name="recommendationSolutionIndex"> The index of the recommendation solution. </param>
        /// <param name="recommendationSolutionContent"> The detail steps of the recommendation solution. </param>
        /// <param name="isRecommendSolution"> Indicates whether this solution is the recommended. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RecommendationSolution(string recommendationSolutionIndex, string recommendationSolutionContent, IsRecommendSolution? isRecommendSolution, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RecommendationSolutionIndex = recommendationSolutionIndex;
            RecommendationSolutionContent = recommendationSolutionContent;
            IsRecommendSolution = isRecommendSolution;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The index of the recommendation solution. </summary>
        public string RecommendationSolutionIndex { get; }
        /// <summary> The detail steps of the recommendation solution. </summary>
        public string RecommendationSolutionContent { get; }
        /// <summary> Indicates whether this solution is the recommended. </summary>
        public IsRecommendSolution? IsRecommendSolution { get; }
    }
}
