// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    public partial class RecommendationSolution : IUtf8JsonSerializable, IJsonModel<RecommendationSolution>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RecommendationSolution>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RecommendationSolution>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecommendationSolution>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RecommendationSolution)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(RecommendationSolutionIndex))
            {
                writer.WritePropertyName("recommendationSolutionIndex"u8);
                writer.WriteStringValue(RecommendationSolutionIndex);
            }
            if (options.Format != "W" && Optional.IsDefined(RecommendationSolutionContent))
            {
                writer.WritePropertyName("recommendationSolutionContent"u8);
                writer.WriteStringValue(RecommendationSolutionContent);
            }
            if (options.Format != "W" && Optional.IsDefined(IsRecommendSolution))
            {
                writer.WritePropertyName("isRecommendSolution"u8);
                writer.WriteStringValue(IsRecommendSolution.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RecommendationSolution IJsonModel<RecommendationSolution>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecommendationSolution>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RecommendationSolution)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRecommendationSolution(document.RootElement, options);
        }

        internal static RecommendationSolution DeserializeRecommendationSolution(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string recommendationSolutionIndex = default;
            string recommendationSolutionContent = default;
            IsRecommendSolution? isRecommendSolution = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("recommendationSolutionIndex"u8))
                {
                    recommendationSolutionIndex = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("recommendationSolutionContent"u8))
                {
                    recommendationSolutionContent = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("isRecommendSolution"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isRecommendSolution = new IsRecommendSolution(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RecommendationSolution(recommendationSolutionIndex, recommendationSolutionContent, isRecommendSolution, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<RecommendationSolution>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecommendationSolution>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(RecommendationSolution)} does not support writing '{options.Format}' format.");
            }
        }

        RecommendationSolution IPersistableModel<RecommendationSolution>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecommendationSolution>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRecommendationSolution(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RecommendationSolution)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RecommendationSolution>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
