// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> A class represent the recommendation. </summary>
    public partial class RecommendationDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RecommendationDetails"/>. </summary>
        internal RecommendationDetails()
        {
            RecommendationSolutions = new ChangeTrackingList<RecommendationSolution>();
        }

        /// <summary> Initializes a new instance of <see cref="RecommendationDetails"/>. </summary>
        /// <param name="recommendationId"> The Id of the recommendation. </param>
        /// <param name="recommendationShortName"> The short name of the recommendation. e.g. "Invalid TLS config". </param>
        /// <param name="recommendationSolutions"> List of recommendation solutions. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RecommendationDetails(string recommendationId, string recommendationShortName, IReadOnlyList<RecommendationSolution> recommendationSolutions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RecommendationId = recommendationId;
            RecommendationShortName = recommendationShortName;
            RecommendationSolutions = recommendationSolutions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Id of the recommendation. </summary>
        public string RecommendationId { get; }
        /// <summary> The short name of the recommendation. e.g. "Invalid TLS config". </summary>
        public string RecommendationShortName { get; }
        /// <summary> List of recommendation solutions. </summary>
        public IReadOnlyList<RecommendationSolution> RecommendationSolutions { get; }
    }
}
