// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    public partial class RecommendationDetails : IUtf8JsonSerializable, IJsonModel<RecommendationDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RecommendationDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RecommendationDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecommendationDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RecommendationDetails)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(RecommendationId))
            {
                writer.WritePropertyName("recommendationId"u8);
                writer.WriteStringValue(RecommendationId);
            }
            if (options.Format != "W" && Optional.IsDefined(RecommendationShortName))
            {
                writer.WritePropertyName("recommendationShortName"u8);
                writer.WriteStringValue(RecommendationShortName);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(RecommendationSolutions))
            {
                writer.WritePropertyName("recommendationSolutions"u8);
                writer.WriteStartArray();
                foreach (var item in RecommendationSolutions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RecommendationDetails IJsonModel<RecommendationDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecommendationDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RecommendationDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRecommendationDetails(document.RootElement, options);
        }

        internal static RecommendationDetails DeserializeRecommendationDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string recommendationId = default;
            string recommendationShortName = default;
            IReadOnlyList<RecommendationSolution> recommendationSolutions = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("recommendationId"u8))
                {
                    recommendationId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("recommendationShortName"u8))
                {
                    recommendationShortName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("recommendationSolutions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<RecommendationSolution> array = new List<RecommendationSolution>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(RecommendationSolution.DeserializeRecommendationSolution(item, options));
                    }
                    recommendationSolutions = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RecommendationDetails(recommendationId, recommendationShortName, recommendationSolutions ?? new ChangeTrackingList<RecommendationSolution>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<RecommendationDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecommendationDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(RecommendationDetails)} does not support writing '{options.Format}' format.");
            }
        }

        RecommendationDetails IPersistableModel<RecommendationDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecommendationDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRecommendationDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RecommendationDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RecommendationDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
