// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> A class represent the quick assessment. </summary>
    public partial class QuickAssessment
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="QuickAssessment"/>. </summary>
        internal QuickAssessment()
        {
        }

        /// <summary> Initializes a new instance of <see cref="QuickAssessment"/>. </summary>
        /// <param name="resourceId"> Resource id. </param>
        /// <param name="responsibilityId"> Responsibility id. </param>
        /// <param name="createdOn"> The timestamp of resource creation (UTC). </param>
        /// <param name="resourceStatus"> Quick assessment status. </param>
        /// <param name="displayName"> Quick assessment display name. </param>
        /// <param name="description"> Quick assessment display name. </param>
        /// <param name="remediationLink"> Link to remediation steps for this quick assessment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal QuickAssessment(ResourceIdentifier resourceId, string responsibilityId, DateTimeOffset? createdOn, ReportResourceStatus? resourceStatus, string displayName, string description, string remediationLink, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceId = resourceId;
            ResponsibilityId = responsibilityId;
            CreatedOn = createdOn;
            ResourceStatus = resourceStatus;
            DisplayName = displayName;
            Description = description;
            RemediationLink = remediationLink;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource id. </summary>
        public ResourceIdentifier ResourceId { get; }
        /// <summary> Responsibility id. </summary>
        public string ResponsibilityId { get; }
        /// <summary> The timestamp of resource creation (UTC). </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> Quick assessment status. </summary>
        public ReportResourceStatus? ResourceStatus { get; }
        /// <summary> Quick assessment display name. </summary>
        public string DisplayName { get; }
        /// <summary> Quick assessment display name. </summary>
        public string Description { get; }
        /// <summary> Link to remediation steps for this quick assessment. </summary>
        public string RemediationLink { get; }
    }
}
