// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> whether to enable ssl verification. </summary>
    public readonly partial struct EnableSslVerification : IEquatable<EnableSslVerification>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EnableSslVerification"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EnableSslVerification(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "true";
        private const string FalseValue = "false";

        /// <summary> The ssl verification is enabled. </summary>
        public static EnableSslVerification True { get; } = new EnableSslVerification(TrueValue);
        /// <summary> The ssl verification is not enabled. </summary>
        public static EnableSslVerification False { get; } = new EnableSslVerification(FalseValue);
        /// <summary> Determines if two <see cref="EnableSslVerification"/> values are the same. </summary>
        public static bool operator ==(EnableSslVerification left, EnableSslVerification right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EnableSslVerification"/> values are not the same. </summary>
        public static bool operator !=(EnableSslVerification left, EnableSslVerification right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EnableSslVerification"/>. </summary>
        public static implicit operator EnableSslVerification(string value) => new EnableSslVerification(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EnableSslVerification other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EnableSslVerification other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
