// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    public partial class CustomerResponsibility : IUtf8JsonSerializable, IJsonModel<CustomerResponsibility>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CustomerResponsibility>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CustomerResponsibility>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomerResponsibility>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CustomerResponsibility)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ResponsibilityId))
            {
                writer.WritePropertyName("responsibilityId"u8);
                writer.WriteStringValue(ResponsibilityId);
            }
            if (options.Format != "W" && Optional.IsDefined(ResponsibilityTitle))
            {
                writer.WritePropertyName("responsibilityTitle"u8);
                writer.WriteStringValue(ResponsibilityTitle);
            }
            if (options.Format != "W" && Optional.IsDefined(ResponsibilityDescription))
            {
                writer.WritePropertyName("responsibilityDescription"u8);
                writer.WriteStringValue(ResponsibilityDescription);
            }
            if (options.Format != "W" && Optional.IsDefined(ResponsibilityType))
            {
                writer.WritePropertyName("responsibilityType"u8);
                writer.WriteStringValue(ResponsibilityType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ResponsibilitySeverity))
            {
                writer.WritePropertyName("responsibilitySeverity"u8);
                writer.WriteStringValue(ResponsibilitySeverity.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ResponsibilityStatus))
            {
                writer.WritePropertyName("responsibilityStatus"u8);
                writer.WriteStringValue(ResponsibilityStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ResponsibilityEnvironment))
            {
                writer.WritePropertyName("responsibilityEnvironment"u8);
                writer.WriteStringValue(ResponsibilityEnvironment.Value.ToString());
            }
            if (Optional.IsDefined(FailedResourceCount))
            {
                writer.WritePropertyName("failedResourceCount"u8);
                writer.WriteNumberValue(FailedResourceCount.Value);
            }
            if (Optional.IsDefined(TotalResourceCount))
            {
                writer.WritePropertyName("totalResourceCount"u8);
                writer.WriteNumberValue(TotalResourceCount.Value);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ResourceList))
            {
                writer.WritePropertyName("resourceList"u8);
                writer.WriteStartArray();
                foreach (var item in ResourceList)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(RecommendationList))
            {
                writer.WritePropertyName("recommendationList"u8);
                writer.WriteStartArray();
                foreach (var item in RecommendationList)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(Guidance))
            {
                writer.WritePropertyName("guidance"u8);
                writer.WriteStringValue(Guidance);
            }
            if (options.Format != "W" && Optional.IsDefined(Justification))
            {
                writer.WritePropertyName("justification"u8);
                writer.WriteStringValue(Justification);
            }
            if (Optional.IsCollectionDefined(EvidenceFiles))
            {
                writer.WritePropertyName("evidenceFiles"u8);
                writer.WriteStartArray();
                foreach (var item in EvidenceFiles)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CustomerResponsibility IJsonModel<CustomerResponsibility>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomerResponsibility>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CustomerResponsibility)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCustomerResponsibility(document.RootElement, options);
        }

        internal static CustomerResponsibility DeserializeCustomerResponsibility(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string responsibilityId = default;
            string responsibilityTitle = default;
            string responsibilityDescription = default;
            ResponsibilityType? responsibilityType = default;
            ResponsibilitySeverity? responsibilitySeverity = default;
            ResponsibilityStatus? responsibilityStatus = default;
            ResponsibilityEnvironment? responsibilityEnvironment = default;
            int? failedResourceCount = default;
            int? totalResourceCount = default;
            IReadOnlyList<ResponsibilityResourceItem> resourceList = default;
            IReadOnlyList<RecommendationDetails> recommendationList = default;
            string guidance = default;
            string justification = default;
            IReadOnlyList<string> evidenceFiles = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("responsibilityId"u8))
                {
                    responsibilityId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("responsibilityTitle"u8))
                {
                    responsibilityTitle = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("responsibilityDescription"u8))
                {
                    responsibilityDescription = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("responsibilityType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    responsibilityType = new ResponsibilityType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("responsibilitySeverity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    responsibilitySeverity = new ResponsibilitySeverity(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("responsibilityStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    responsibilityStatus = new ResponsibilityStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("responsibilityEnvironment"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    responsibilityEnvironment = new ResponsibilityEnvironment(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("failedResourceCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    failedResourceCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("totalResourceCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalResourceCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("resourceList"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ResponsibilityResourceItem> array = new List<ResponsibilityResourceItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ResponsibilityResourceItem.DeserializeResponsibilityResourceItem(item, options));
                    }
                    resourceList = array;
                    continue;
                }
                if (property.NameEquals("recommendationList"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<RecommendationDetails> array = new List<RecommendationDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(RecommendationDetails.DeserializeRecommendationDetails(item, options));
                    }
                    recommendationList = array;
                    continue;
                }
                if (property.NameEquals("guidance"u8))
                {
                    guidance = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("justification"u8))
                {
                    justification = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("evidenceFiles"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    evidenceFiles = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CustomerResponsibility(
                responsibilityId,
                responsibilityTitle,
                responsibilityDescription,
                responsibilityType,
                responsibilitySeverity,
                responsibilityStatus,
                responsibilityEnvironment,
                failedResourceCount,
                totalResourceCount,
                resourceList ?? new ChangeTrackingList<ResponsibilityResourceItem>(),
                recommendationList ?? new ChangeTrackingList<RecommendationDetails>(),
                guidance,
                justification,
                evidenceFiles ?? new ChangeTrackingList<string>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CustomerResponsibility>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomerResponsibility>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CustomerResponsibility)} does not support writing '{options.Format}' format.");
            }
        }

        CustomerResponsibility IPersistableModel<CustomerResponsibility>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomerResponsibility>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCustomerResponsibility(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CustomerResponsibility)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CustomerResponsibility>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
