// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    public partial class CertSyncRecord : IUtf8JsonSerializable, IJsonModel<CertSyncRecord>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CertSyncRecord>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CertSyncRecord>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CertSyncRecord>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CertSyncRecord)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(OfferGuid))
            {
                writer.WritePropertyName("offerGuid"u8);
                writer.WriteStringValue(OfferGuid);
            }
            if (Optional.IsDefined(CertificationStatus))
            {
                writer.WritePropertyName("certificationStatus"u8);
                writer.WriteStringValue(CertificationStatus);
            }
            if (Optional.IsDefined(IngestionStatus))
            {
                writer.WritePropertyName("ingestionStatus"u8);
                writer.WriteStringValue(IngestionStatus);
            }
            if (Optional.IsCollectionDefined(Controls))
            {
                writer.WritePropertyName("controls"u8);
                writer.WriteStartArray();
                foreach (var item in Controls)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CertSyncRecord IJsonModel<CertSyncRecord>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CertSyncRecord>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CertSyncRecord)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCertSyncRecord(document.RootElement, options);
        }

        internal static CertSyncRecord DeserializeCertSyncRecord(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string offerGuid = default;
            string certificationStatus = default;
            string ingestionStatus = default;
            IList<ControlSyncRecord> controls = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("offerGuid"u8))
                {
                    offerGuid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("certificationStatus"u8))
                {
                    certificationStatus = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ingestionStatus"u8))
                {
                    ingestionStatus = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("controls"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ControlSyncRecord> array = new List<ControlSyncRecord>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ControlSyncRecord.DeserializeControlSyncRecord(item, options));
                    }
                    controls = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CertSyncRecord(offerGuid, certificationStatus, ingestionStatus, controls ?? new ChangeTrackingList<ControlSyncRecord>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CertSyncRecord>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CertSyncRecord>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CertSyncRecord)} does not support writing '{options.Format}' format.");
            }
        }

        CertSyncRecord IPersistableModel<CertSyncRecord>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CertSyncRecord>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCertSyncRecord(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CertSyncRecord)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CertSyncRecord>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
