// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    public partial class AppComplianceReportWebhookProperties : IUtf8JsonSerializable, IJsonModel<AppComplianceReportWebhookProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AppComplianceReportWebhookProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AppComplianceReportWebhookProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceReportWebhookProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AppComplianceReportWebhookProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(WebhookId))
            {
                writer.WritePropertyName("webhookId"u8);
                writer.WriteStringValue(WebhookId);
            }
            if (Optional.IsDefined(Status))
            {
                writer.WritePropertyName("status"u8);
                writer.WriteStringValue(Status.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(TenantId))
            {
                writer.WritePropertyName("tenantId"u8);
                writer.WriteStringValue(TenantId.Value);
            }
            if (Optional.IsDefined(SendAllEvents))
            {
                writer.WritePropertyName("sendAllEvents"u8);
                writer.WriteStringValue(SendAllEvents.Value.ToString());
            }
            if (Optional.IsCollectionDefined(Events))
            {
                writer.WritePropertyName("events"u8);
                writer.WriteStartArray();
                foreach (var item in Events)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(PayloadUri))
            {
                writer.WritePropertyName("payloadUrl"u8);
                writer.WriteStringValue(PayloadUri.AbsoluteUri);
            }
            if (Optional.IsDefined(ContentType))
            {
                writer.WritePropertyName("contentType"u8);
                writer.WriteStringValue(ContentType.Value.ToString());
            }
            if (Optional.IsDefined(WebhookKey))
            {
                writer.WritePropertyName("webhookKey"u8);
                writer.WriteStringValue(WebhookKey);
            }
            if (Optional.IsDefined(UpdateWebhookKey))
            {
                writer.WritePropertyName("updateWebhookKey"u8);
                writer.WriteStringValue(UpdateWebhookKey.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(WebhookKeyEnabled))
            {
                writer.WritePropertyName("webhookKeyEnabled"u8);
                writer.WriteStringValue(WebhookKeyEnabled.Value.ToString());
            }
            if (Optional.IsDefined(EnableSslVerification))
            {
                writer.WritePropertyName("enableSslVerification"u8);
                writer.WriteStringValue(EnableSslVerification.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(DeliveryStatus))
            {
                writer.WritePropertyName("deliveryStatus"u8);
                writer.WriteStringValue(DeliveryStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AppComplianceReportWebhookProperties IJsonModel<AppComplianceReportWebhookProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceReportWebhookProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AppComplianceReportWebhookProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAppComplianceReportWebhookProperties(document.RootElement, options);
        }

        internal static AppComplianceReportWebhookProperties DeserializeAppComplianceReportWebhookProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string webhookId = default;
            WebhookStatus? status = default;
            Guid? tenantId = default;
            SendAllEvent? sendAllEvents = default;
            IList<WebhookNotificationEvent> events = default;
            Uri payloadUrl = default;
            WebhookContentType? contentType = default;
            string webhookKey = default;
            UpdateWebhookKey? updateWebhookKey = default;
            WebhookKeyEnabled? webhookKeyEnabled = default;
            EnableSslVerification? enableSslVerification = default;
            WebhookDeliveryStatus? deliveryStatus = default;
            AppComplianceProvisioningState? provisioningState = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("webhookId"u8))
                {
                    webhookId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    status = new WebhookStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("tenantId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    tenantId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("sendAllEvents"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sendAllEvents = new SendAllEvent(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("events"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<WebhookNotificationEvent> array = new List<WebhookNotificationEvent>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new WebhookNotificationEvent(item.GetString()));
                    }
                    events = array;
                    continue;
                }
                if (property.NameEquals("payloadUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    payloadUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("contentType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    contentType = new WebhookContentType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("webhookKey"u8))
                {
                    webhookKey = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("updateWebhookKey"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    updateWebhookKey = new UpdateWebhookKey(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("webhookKeyEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    webhookKeyEnabled = new WebhookKeyEnabled(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("enableSslVerification"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enableSslVerification = new EnableSslVerification(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("deliveryStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    deliveryStatus = new WebhookDeliveryStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new AppComplianceProvisioningState(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AppComplianceReportWebhookProperties(
                webhookId,
                status,
                tenantId,
                sendAllEvents,
                events ?? new ChangeTrackingList<WebhookNotificationEvent>(),
                payloadUrl,
                contentType,
                webhookKey,
                updateWebhookKey,
                webhookKeyEnabled,
                enableSslVerification,
                deliveryStatus,
                provisioningState,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AppComplianceReportWebhookProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceReportWebhookProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AppComplianceReportWebhookProperties)} does not support writing '{options.Format}' format.");
            }
        }

        AppComplianceReportWebhookProperties IPersistableModel<AppComplianceReportWebhookProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceReportWebhookProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAppComplianceReportWebhookProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AppComplianceReportWebhookProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AppComplianceReportWebhookProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
