// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> The reason why the given name is not available. </summary>
    public readonly partial struct AppComplianceReportNameUnavailabilityReason : IEquatable<AppComplianceReportNameUnavailabilityReason>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppComplianceReportNameUnavailabilityReason"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppComplianceReportNameUnavailabilityReason(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string AlreadyExistsValue = "AlreadyExists";

        /// <summary> Invalid. </summary>
        public static AppComplianceReportNameUnavailabilityReason Invalid { get; } = new AppComplianceReportNameUnavailabilityReason(InvalidValue);
        /// <summary> AlreadyExists. </summary>
        public static AppComplianceReportNameUnavailabilityReason AlreadyExists { get; } = new AppComplianceReportNameUnavailabilityReason(AlreadyExistsValue);
        /// <summary> Determines if two <see cref="AppComplianceReportNameUnavailabilityReason"/> values are the same. </summary>
        public static bool operator ==(AppComplianceReportNameUnavailabilityReason left, AppComplianceReportNameUnavailabilityReason right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppComplianceReportNameUnavailabilityReason"/> values are not the same. </summary>
        public static bool operator !=(AppComplianceReportNameUnavailabilityReason left, AppComplianceReportNameUnavailabilityReason right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppComplianceReportNameUnavailabilityReason"/>. </summary>
        public static implicit operator AppComplianceReportNameUnavailabilityReason(string value) => new AppComplianceReportNameUnavailabilityReason(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppComplianceReportNameUnavailabilityReason other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppComplianceReportNameUnavailabilityReason other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
