// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> Evidence type. </summary>
    public readonly partial struct AppComplianceReportEvidenceType : IEquatable<AppComplianceReportEvidenceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppComplianceReportEvidenceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppComplianceReportEvidenceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FileValue = "File";
        private const string AutoCollectedEvidenceValue = "AutoCollectedEvidence";
        private const string DataValue = "Data";

        /// <summary> The evidence is a file. </summary>
        public static AppComplianceReportEvidenceType File { get; } = new AppComplianceReportEvidenceType(FileValue);
        /// <summary> The evidence auto collected by App Compliance Automation. </summary>
        public static AppComplianceReportEvidenceType AutoCollectedEvidence { get; } = new AppComplianceReportEvidenceType(AutoCollectedEvidenceValue);
        /// <summary> The evidence is data. </summary>
        public static AppComplianceReportEvidenceType Data { get; } = new AppComplianceReportEvidenceType(DataValue);
        /// <summary> Determines if two <see cref="AppComplianceReportEvidenceType"/> values are the same. </summary>
        public static bool operator ==(AppComplianceReportEvidenceType left, AppComplianceReportEvidenceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppComplianceReportEvidenceType"/> values are not the same. </summary>
        public static bool operator !=(AppComplianceReportEvidenceType left, AppComplianceReportEvidenceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppComplianceReportEvidenceType"/>. </summary>
        public static implicit operator AppComplianceReportEvidenceType(string value) => new AppComplianceReportEvidenceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppComplianceReportEvidenceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppComplianceReportEvidenceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
