// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> Evidence's properties. </summary>
    public partial class AppComplianceReportEvidenceProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppComplianceReportEvidenceProperties"/>. </summary>
        /// <param name="filePath"> The path of the file in storage. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="filePath"/> is null. </exception>
        public AppComplianceReportEvidenceProperties(string filePath)
        {
            Argument.AssertNotNull(filePath, nameof(filePath));

            FilePath = filePath;
        }

        /// <summary> Initializes a new instance of <see cref="AppComplianceReportEvidenceProperties"/>. </summary>
        /// <param name="evidenceType"> Evidence type. </param>
        /// <param name="filePath"> The path of the file in storage. </param>
        /// <param name="extraData"> Extra data considered as evidence. </param>
        /// <param name="controlId"> Control id. </param>
        /// <param name="responsibilityId"> Responsibility id. </param>
        /// <param name="provisioningState"> Azure lifecycle management. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppComplianceReportEvidenceProperties(AppComplianceReportEvidenceType? evidenceType, string filePath, string extraData, string controlId, string responsibilityId, AppComplianceProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EvidenceType = evidenceType;
            FilePath = filePath;
            ExtraData = extraData;
            ControlId = controlId;
            ResponsibilityId = responsibilityId;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AppComplianceReportEvidenceProperties"/> for deserialization. </summary>
        internal AppComplianceReportEvidenceProperties()
        {
        }

        /// <summary> Evidence type. </summary>
        public AppComplianceReportEvidenceType? EvidenceType { get; set; }
        /// <summary> The path of the file in storage. </summary>
        public string FilePath { get; set; }
        /// <summary> Extra data considered as evidence. </summary>
        public string ExtraData { get; set; }
        /// <summary> Control id. </summary>
        public string ControlId { get; set; }
        /// <summary> Responsibility id. </summary>
        public string ResponsibilityId { get; set; }
        /// <summary> Azure lifecycle management. </summary>
        public AppComplianceProvisioningState? ProvisioningState { get; }
    }
}
