// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    public partial class AppComplianceGetOverviewStatusResult : IUtf8JsonSerializable, IJsonModel<AppComplianceGetOverviewStatusResult>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AppComplianceGetOverviewStatusResult>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AppComplianceGetOverviewStatusResult>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceGetOverviewStatusResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AppComplianceGetOverviewStatusResult)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(StatusList))
            {
                writer.WritePropertyName("statusList"u8);
                writer.WriteStartArray();
                foreach (var item in StatusList)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AppComplianceGetOverviewStatusResult IJsonModel<AppComplianceGetOverviewStatusResult>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceGetOverviewStatusResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AppComplianceGetOverviewStatusResult)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAppComplianceGetOverviewStatusResult(document.RootElement, options);
        }

        internal static AppComplianceGetOverviewStatusResult DeserializeAppComplianceGetOverviewStatusResult(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<OverviewStatusItem> statusList = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("statusList"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<OverviewStatusItem> array = new List<OverviewStatusItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(OverviewStatusItem.DeserializeOverviewStatusItem(item, options));
                    }
                    statusList = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AppComplianceGetOverviewStatusResult(statusList ?? new ChangeTrackingList<OverviewStatusItem>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AppComplianceGetOverviewStatusResult>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceGetOverviewStatusResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AppComplianceGetOverviewStatusResult)} does not support writing '{options.Format}' format.");
            }
        }

        AppComplianceGetOverviewStatusResult IPersistableModel<AppComplianceGetOverviewStatusResult>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceGetOverviewStatusResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAppComplianceGetOverviewStatusResult(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AppComplianceGetOverviewStatusResult)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AppComplianceGetOverviewStatusResult>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
