// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> Indicates the download type. </summary>
    public readonly partial struct AppComplianceDownloadType : IEquatable<AppComplianceDownloadType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppComplianceDownloadType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppComplianceDownloadType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ComplianceReportValue = "ComplianceReport";
        private const string CompliancePdfReportValue = "CompliancePdfReport";
        private const string ComplianceDetailedPdfReportValue = "ComplianceDetailedPdfReport";
        private const string ResourceListValue = "ResourceList";

        /// <summary> Download the compliance report. </summary>
        public static AppComplianceDownloadType ComplianceReport { get; } = new AppComplianceDownloadType(ComplianceReportValue);
        /// <summary> Download the compliance pdf report. </summary>
        public static AppComplianceDownloadType CompliancePdfReport { get; } = new AppComplianceDownloadType(CompliancePdfReportValue);
        /// <summary> Download the detailed compliance pdf report. </summary>
        public static AppComplianceDownloadType ComplianceDetailedPdfReport { get; } = new AppComplianceDownloadType(ComplianceDetailedPdfReportValue);
        /// <summary> Download the resource list of the report. </summary>
        public static AppComplianceDownloadType ResourceList { get; } = new AppComplianceDownloadType(ResourceListValue);
        /// <summary> Determines if two <see cref="AppComplianceDownloadType"/> values are the same. </summary>
        public static bool operator ==(AppComplianceDownloadType left, AppComplianceDownloadType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppComplianceDownloadType"/> values are not the same. </summary>
        public static bool operator !=(AppComplianceDownloadType left, AppComplianceDownloadType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppComplianceDownloadType"/>. </summary>
        public static implicit operator AppComplianceDownloadType(string value) => new AppComplianceDownloadType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppComplianceDownloadType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppComplianceDownloadType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
