// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    public partial class AppComplianceDownloadResult : IUtf8JsonSerializable, IJsonModel<AppComplianceDownloadResult>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AppComplianceDownloadResult>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AppComplianceDownloadResult>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceDownloadResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AppComplianceDownloadResult)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsCollectionDefined(ResourceList))
            {
                writer.WritePropertyName("resourceList"u8);
                writer.WriteStartArray();
                foreach (var item in ResourceList)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ComplianceReport))
            {
                writer.WritePropertyName("complianceReport"u8);
                writer.WriteStartArray();
                foreach (var item in ComplianceReport)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(CompliancePdfReport))
            {
                writer.WritePropertyName("compliancePdfReport"u8);
                writer.WriteObjectValue(CompliancePdfReport, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ComplianceDetailedPdfReport))
            {
                writer.WritePropertyName("complianceDetailedPdfReport"u8);
                writer.WriteObjectValue(ComplianceDetailedPdfReport, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AppComplianceDownloadResult IJsonModel<AppComplianceDownloadResult>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceDownloadResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AppComplianceDownloadResult)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAppComplianceDownloadResult(document.RootElement, options);
        }

        internal static AppComplianceDownloadResult DeserializeAppComplianceDownloadResult(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<ReportResourceItem> resourceList = default;
            IReadOnlyList<AppComplianceReportItem> complianceReport = default;
            AppCompliancePdfReport compliancePdfReport = default;
            AppComplianceDetailedPdfReport complianceDetailedPdfReport = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("resourceList"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ReportResourceItem> array = new List<ReportResourceItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ReportResourceItem.DeserializeReportResourceItem(item, options));
                    }
                    resourceList = array;
                    continue;
                }
                if (property.NameEquals("complianceReport"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AppComplianceReportItem> array = new List<AppComplianceReportItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AppComplianceReportItem.DeserializeAppComplianceReportItem(item, options));
                    }
                    complianceReport = array;
                    continue;
                }
                if (property.NameEquals("compliancePdfReport"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    compliancePdfReport = AppCompliancePdfReport.DeserializeAppCompliancePdfReport(property.Value, options);
                    continue;
                }
                if (property.NameEquals("complianceDetailedPdfReport"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    complianceDetailedPdfReport = AppComplianceDetailedPdfReport.DeserializeAppComplianceDetailedPdfReport(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AppComplianceDownloadResult(resourceList ?? new ChangeTrackingList<ReportResourceItem>(), complianceReport ?? new ChangeTrackingList<AppComplianceReportItem>(), compliancePdfReport, complianceDetailedPdfReport, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AppComplianceDownloadResult>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceDownloadResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AppComplianceDownloadResult)} does not support writing '{options.Format}' format.");
            }
        }

        AppComplianceDownloadResult IPersistableModel<AppComplianceDownloadResult>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceDownloadResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAppComplianceDownloadResult(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AppComplianceDownloadResult)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AppComplianceDownloadResult>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
