// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> Indicates the control status. </summary>
    public readonly partial struct AppComplianceControlStatus : IEquatable<AppComplianceControlStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppComplianceControlStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppComplianceControlStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PassedValue = "Passed";
        private const string FailedValue = "Failed";
        private const string NotApplicableValue = "NotApplicable";
        private const string PendingApprovalValue = "PendingApproval";

        /// <summary> The control is passed. </summary>
        public static AppComplianceControlStatus Passed { get; } = new AppComplianceControlStatus(PassedValue);
        /// <summary> The control is failed. </summary>
        public static AppComplianceControlStatus Failed { get; } = new AppComplianceControlStatus(FailedValue);
        /// <summary> The control is not applicable. </summary>
        public static AppComplianceControlStatus NotApplicable { get; } = new AppComplianceControlStatus(NotApplicableValue);
        /// <summary> The control is pending for approval. </summary>
        public static AppComplianceControlStatus PendingApproval { get; } = new AppComplianceControlStatus(PendingApprovalValue);
        /// <summary> Determines if two <see cref="AppComplianceControlStatus"/> values are the same. </summary>
        public static bool operator ==(AppComplianceControlStatus left, AppComplianceControlStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppComplianceControlStatus"/> values are not the same. </summary>
        public static bool operator !=(AppComplianceControlStatus left, AppComplianceControlStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppComplianceControlStatus"/>. </summary>
        public static implicit operator AppComplianceControlStatus(string value) => new AppComplianceControlStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppComplianceControlStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppComplianceControlStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
