// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> A class represent the control family. </summary>
    public partial class AppComplianceControlFamily
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppComplianceControlFamily"/>. </summary>
        internal AppComplianceControlFamily()
        {
            Controls = new ChangeTrackingList<AppComplianceControl>();
        }

        /// <summary> Initializes a new instance of <see cref="AppComplianceControlFamily"/>. </summary>
        /// <param name="controlFamilyName"> The name of the control family. e.g. "Malware Protection - Anti-Virus". </param>
        /// <param name="controlFamilyStatus"> The control family status. </param>
        /// <param name="controls"> List of controls. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppComplianceControlFamily(string controlFamilyName, ControlFamilyStatus? controlFamilyStatus, IReadOnlyList<AppComplianceControl> controls, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ControlFamilyName = controlFamilyName;
            ControlFamilyStatus = controlFamilyStatus;
            Controls = controls;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the control family. e.g. "Malware Protection - Anti-Virus". </summary>
        public string ControlFamilyName { get; }
        /// <summary> The control family status. </summary>
        public ControlFamilyStatus? ControlFamilyStatus { get; }
        /// <summary> List of controls. </summary>
        public IReadOnlyList<AppComplianceControl> Controls { get; }
    }
}
