// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    public partial class AppComplianceControlFamily : IUtf8JsonSerializable, IJsonModel<AppComplianceControlFamily>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AppComplianceControlFamily>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AppComplianceControlFamily>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceControlFamily>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AppComplianceControlFamily)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ControlFamilyName))
            {
                writer.WritePropertyName("controlFamilyName"u8);
                writer.WriteStringValue(ControlFamilyName);
            }
            if (options.Format != "W" && Optional.IsDefined(ControlFamilyStatus))
            {
                writer.WritePropertyName("controlFamilyStatus"u8);
                writer.WriteStringValue(ControlFamilyStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Controls))
            {
                writer.WritePropertyName("controls"u8);
                writer.WriteStartArray();
                foreach (var item in Controls)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AppComplianceControlFamily IJsonModel<AppComplianceControlFamily>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceControlFamily>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AppComplianceControlFamily)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAppComplianceControlFamily(document.RootElement, options);
        }

        internal static AppComplianceControlFamily DeserializeAppComplianceControlFamily(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string controlFamilyName = default;
            ControlFamilyStatus? controlFamilyStatus = default;
            IReadOnlyList<AppComplianceControl> controls = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("controlFamilyName"u8))
                {
                    controlFamilyName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("controlFamilyStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    controlFamilyStatus = new ControlFamilyStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("controls"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AppComplianceControl> array = new List<AppComplianceControl>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AppComplianceControl.DeserializeAppComplianceControl(item, options));
                    }
                    controls = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AppComplianceControlFamily(controlFamilyName, controlFamilyStatus, controls ?? new ChangeTrackingList<AppComplianceControl>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AppComplianceControlFamily>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceControlFamily>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AppComplianceControlFamily)} does not support writing '{options.Format}' format.");
            }
        }

        AppComplianceControlFamily IPersistableModel<AppComplianceControlFamily>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceControlFamily>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAppComplianceControlFamily(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AppComplianceControlFamily)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AppComplianceControlFamily>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
