// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> A class represent the control. </summary>
    public partial class AppComplianceControl
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppComplianceControl"/>. </summary>
        internal AppComplianceControl()
        {
            Responsibilities = new ChangeTrackingList<CustomerResponsibility>();
        }

        /// <summary> Initializes a new instance of <see cref="AppComplianceControl"/>. </summary>
        /// <param name="controlId"> The Id of the control. e.g. "Operational_Security_10". </param>
        /// <param name="controlName"> The name of the control. e.g. "Unsupported OS and Software.". </param>
        /// <param name="controlFullName"> The full name of the control. e.g. "Validate that unsupported operating systems and software components are not in use.". </param>
        /// <param name="controlDescription"> The control's description. </param>
        /// <param name="controlDescriptionHyperLink"> The hyper link to the control's description'. </param>
        /// <param name="controlStatus"> Control status. </param>
        /// <param name="responsibilities"> List of customer responsibility. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppComplianceControl(string controlId, string controlName, string controlFullName, string controlDescription, Uri controlDescriptionHyperLink, AppComplianceControlStatus? controlStatus, IReadOnlyList<CustomerResponsibility> responsibilities, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ControlId = controlId;
            ControlName = controlName;
            ControlFullName = controlFullName;
            ControlDescription = controlDescription;
            ControlDescriptionHyperLink = controlDescriptionHyperLink;
            ControlStatus = controlStatus;
            Responsibilities = responsibilities;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Id of the control. e.g. "Operational_Security_10". </summary>
        public string ControlId { get; }
        /// <summary> The name of the control. e.g. "Unsupported OS and Software.". </summary>
        public string ControlName { get; }
        /// <summary> The full name of the control. e.g. "Validate that unsupported operating systems and software components are not in use.". </summary>
        public string ControlFullName { get; }
        /// <summary> The control's description. </summary>
        public string ControlDescription { get; }
        /// <summary> The hyper link to the control's description'. </summary>
        public Uri ControlDescriptionHyperLink { get; }
        /// <summary> Control status. </summary>
        public AppComplianceControlStatus? ControlStatus { get; }
        /// <summary> List of customer responsibility. </summary>
        public IReadOnlyList<CustomerResponsibility> Responsibilities { get; }
    }
}
