// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    public partial class AppComplianceControl : IUtf8JsonSerializable, IJsonModel<AppComplianceControl>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AppComplianceControl>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AppComplianceControl>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceControl>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AppComplianceControl)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ControlId))
            {
                writer.WritePropertyName("controlId"u8);
                writer.WriteStringValue(ControlId);
            }
            if (options.Format != "W" && Optional.IsDefined(ControlName))
            {
                writer.WritePropertyName("controlName"u8);
                writer.WriteStringValue(ControlName);
            }
            if (options.Format != "W" && Optional.IsDefined(ControlFullName))
            {
                writer.WritePropertyName("controlFullName"u8);
                writer.WriteStringValue(ControlFullName);
            }
            if (options.Format != "W" && Optional.IsDefined(ControlDescription))
            {
                writer.WritePropertyName("controlDescription"u8);
                writer.WriteStringValue(ControlDescription);
            }
            if (options.Format != "W" && Optional.IsDefined(ControlDescriptionHyperLink))
            {
                writer.WritePropertyName("controlDescriptionHyperLink"u8);
                writer.WriteStringValue(ControlDescriptionHyperLink.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(ControlStatus))
            {
                writer.WritePropertyName("controlStatus"u8);
                writer.WriteStringValue(ControlStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Responsibilities))
            {
                writer.WritePropertyName("responsibilities"u8);
                writer.WriteStartArray();
                foreach (var item in Responsibilities)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AppComplianceControl IJsonModel<AppComplianceControl>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceControl>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AppComplianceControl)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAppComplianceControl(document.RootElement, options);
        }

        internal static AppComplianceControl DeserializeAppComplianceControl(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string controlId = default;
            string controlName = default;
            string controlFullName = default;
            string controlDescription = default;
            Uri controlDescriptionHyperLink = default;
            AppComplianceControlStatus? controlStatus = default;
            IReadOnlyList<CustomerResponsibility> responsibilities = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("controlId"u8))
                {
                    controlId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("controlName"u8))
                {
                    controlName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("controlFullName"u8))
                {
                    controlFullName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("controlDescription"u8))
                {
                    controlDescription = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("controlDescriptionHyperLink"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    controlDescriptionHyperLink = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("controlStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    controlStatus = new AppComplianceControlStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("responsibilities"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<CustomerResponsibility> array = new List<CustomerResponsibility>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CustomerResponsibility.DeserializeCustomerResponsibility(item, options));
                    }
                    responsibilities = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AppComplianceControl(
                controlId,
                controlName,
                controlFullName,
                controlDescription,
                controlDescriptionHyperLink,
                controlStatus,
                responsibilities ?? new ChangeTrackingList<CustomerResponsibility>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AppComplianceControl>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceControl>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AppComplianceControl)} does not support writing '{options.Format}' format.");
            }
        }

        AppComplianceControl IPersistableModel<AppComplianceControl>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceControl>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAppComplianceControl(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AppComplianceControl)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AppComplianceControl>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
