// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> Indicates the category status. </summary>
    public readonly partial struct AppComplianceCategoryStatus : IEquatable<AppComplianceCategoryStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppComplianceCategoryStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppComplianceCategoryStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PassedValue = "Passed";
        private const string FailedValue = "Failed";
        private const string NotApplicableValue = "NotApplicable";
        private const string PendingApprovalValue = "PendingApproval";

        /// <summary> The category is passed. </summary>
        public static AppComplianceCategoryStatus Passed { get; } = new AppComplianceCategoryStatus(PassedValue);
        /// <summary> The category is failed. </summary>
        public static AppComplianceCategoryStatus Failed { get; } = new AppComplianceCategoryStatus(FailedValue);
        /// <summary> The category is not applicable. </summary>
        public static AppComplianceCategoryStatus NotApplicable { get; } = new AppComplianceCategoryStatus(NotApplicableValue);
        /// <summary> The category is pending for approval. </summary>
        public static AppComplianceCategoryStatus PendingApproval { get; } = new AppComplianceCategoryStatus(PendingApprovalValue);
        /// <summary> Determines if two <see cref="AppComplianceCategoryStatus"/> values are the same. </summary>
        public static bool operator ==(AppComplianceCategoryStatus left, AppComplianceCategoryStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppComplianceCategoryStatus"/> values are not the same. </summary>
        public static bool operator !=(AppComplianceCategoryStatus left, AppComplianceCategoryStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppComplianceCategoryStatus"/>. </summary>
        public static implicit operator AppComplianceCategoryStatus(string value) => new AppComplianceCategoryStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppComplianceCategoryStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppComplianceCategoryStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
