// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> A class represent the compliance category. </summary>
    public partial class AppComplianceCategory
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppComplianceCategory"/>. </summary>
        internal AppComplianceCategory()
        {
            ControlFamilies = new ChangeTrackingList<AppComplianceControlFamily>();
        }

        /// <summary> Initializes a new instance of <see cref="AppComplianceCategory"/>. </summary>
        /// <param name="categoryName"> The name of the compliance category. e.g. "Operational Security". </param>
        /// <param name="categoryStatus"> Category status. </param>
        /// <param name="controlFamilies"> List of control families. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppComplianceCategory(string categoryName, AppComplianceCategoryStatus? categoryStatus, IReadOnlyList<AppComplianceControlFamily> controlFamilies, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CategoryName = categoryName;
            CategoryStatus = categoryStatus;
            ControlFamilies = controlFamilies;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the compliance category. e.g. "Operational Security". </summary>
        public string CategoryName { get; }
        /// <summary> Category status. </summary>
        public AppComplianceCategoryStatus? CategoryStatus { get; }
        /// <summary> List of control families. </summary>
        public IReadOnlyList<AppComplianceControlFamily> ControlFamilies { get; }
    }
}
