// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    public partial class AppComplianceCategory : IUtf8JsonSerializable, IJsonModel<AppComplianceCategory>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AppComplianceCategory>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AppComplianceCategory>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceCategory>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AppComplianceCategory)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(CategoryName))
            {
                writer.WritePropertyName("categoryName"u8);
                writer.WriteStringValue(CategoryName);
            }
            if (options.Format != "W" && Optional.IsDefined(CategoryStatus))
            {
                writer.WritePropertyName("categoryStatus"u8);
                writer.WriteStringValue(CategoryStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ControlFamilies))
            {
                writer.WritePropertyName("controlFamilies"u8);
                writer.WriteStartArray();
                foreach (var item in ControlFamilies)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AppComplianceCategory IJsonModel<AppComplianceCategory>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceCategory>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AppComplianceCategory)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAppComplianceCategory(document.RootElement, options);
        }

        internal static AppComplianceCategory DeserializeAppComplianceCategory(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string categoryName = default;
            AppComplianceCategoryStatus? categoryStatus = default;
            IReadOnlyList<AppComplianceControlFamily> controlFamilies = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("categoryName"u8))
                {
                    categoryName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("categoryStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    categoryStatus = new AppComplianceCategoryStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("controlFamilies"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AppComplianceControlFamily> array = new List<AppComplianceControlFamily>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AppComplianceControlFamily.DeserializeAppComplianceControlFamily(item, options));
                    }
                    controlFamilies = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AppComplianceCategory(categoryName, categoryStatus, controlFamilies ?? new ChangeTrackingList<AppComplianceControlFamily>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AppComplianceCategory>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceCategory>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AppComplianceCategory)} does not support writing '{options.Format}' format.");
            }
        }

        AppComplianceCategory IPersistableModel<AppComplianceCategory>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppComplianceCategory>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAppComplianceCategory(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AppComplianceCategory)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AppComplianceCategory>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
