// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.AppComplianceAutomation.Models;

namespace Azure.ResourceManager.AppComplianceAutomation
{
    internal class SyncCertRecordResultOperationSource : IOperationSource<SyncCertRecordResult>
    {
        SyncCertRecordResult IOperationSource<SyncCertRecordResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return SyncCertRecordResult.DeserializeSyncCertRecordResult(document.RootElement);
        }

        async ValueTask<SyncCertRecordResult> IOperationSource<SyncCertRecordResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return SyncCertRecordResult.DeserializeSyncCertRecordResult(document.RootElement);
        }
    }
}
