// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.AppComplianceAutomation.Models;

namespace Azure.ResourceManager.AppComplianceAutomation
{
    internal class ReportVerificationResultOperationSource : IOperationSource<ReportVerificationResult>
    {
        ReportVerificationResult IOperationSource<ReportVerificationResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return ReportVerificationResult.DeserializeReportVerificationResult(document.RootElement);
        }

        async ValueTask<ReportVerificationResult> IOperationSource<ReportVerificationResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return ReportVerificationResult.DeserializeReportVerificationResult(document.RootElement);
        }
    }
}
