// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.AppComplianceAutomation.Models;

namespace Azure.ResourceManager.AppComplianceAutomation
{
    internal class ReportFixResultOperationSource : IOperationSource<ReportFixResult>
    {
        ReportFixResult IOperationSource<ReportFixResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return ReportFixResult.DeserializeReportFixResult(document.RootElement);
        }

        async ValueTask<ReportFixResult> IOperationSource<ReportFixResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return ReportFixResult.DeserializeReportFixResult(document.RootElement);
        }
    }
}
