// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppComplianceAutomation
{
    internal class AppComplianceReportOperationSource : IOperationSource<AppComplianceReportResource>
    {
        private readonly ArmClient _client;

        internal AppComplianceReportOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppComplianceReportResource IOperationSource<AppComplianceReportResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppComplianceReportData.DeserializeAppComplianceReportData(document.RootElement);
            return new AppComplianceReportResource(_client, data);
        }

        async ValueTask<AppComplianceReportResource> IOperationSource<AppComplianceReportResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppComplianceReportData.DeserializeAppComplianceReportData(document.RootElement);
            return new AppComplianceReportResource(_client, data);
        }
    }
}
