// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.AppComplianceAutomation.Models;

namespace Azure.ResourceManager.AppComplianceAutomation
{
    /// <summary>
    /// A class representing a collection of <see cref="AppComplianceReportWebhookResource"/> and their operations.
    /// Each <see cref="AppComplianceReportWebhookResource"/> in the collection will belong to the same instance of <see cref="AppComplianceReportResource"/>.
    /// To get an <see cref="AppComplianceReportWebhookCollection"/> instance call the GetAppComplianceReportWebhooks method from an instance of <see cref="AppComplianceReportResource"/>.
    /// </summary>
    public partial class AppComplianceReportWebhookCollection : ArmCollection, IEnumerable<AppComplianceReportWebhookResource>, IAsyncEnumerable<AppComplianceReportWebhookResource>
    {
        private readonly ClientDiagnostics _appComplianceReportWebhookWebhookClientDiagnostics;
        private readonly WebhookRestOperations _appComplianceReportWebhookWebhookRestClient;

        /// <summary> Initializes a new instance of the <see cref="AppComplianceReportWebhookCollection"/> class for mocking. </summary>
        protected AppComplianceReportWebhookCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AppComplianceReportWebhookCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal AppComplianceReportWebhookCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _appComplianceReportWebhookWebhookClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.AppComplianceAutomation", AppComplianceReportWebhookResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(AppComplianceReportWebhookResource.ResourceType, out string appComplianceReportWebhookWebhookApiVersion);
            _appComplianceReportWebhookWebhookRestClient = new WebhookRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, appComplianceReportWebhookWebhookApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != AppComplianceReportResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, AppComplianceReportResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create a new AppComplianceAutomation webhook or update an exiting AppComplianceAutomation webhook.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/webhooks/{webhookName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Webhook_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportWebhookResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="webhookName"> Webhook Name. </param>
        /// <param name="data"> Parameters for the create or update operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="webhookName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="webhookName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<AppComplianceReportWebhookResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string webhookName, AppComplianceReportWebhookData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(webhookName, nameof(webhookName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _appComplianceReportWebhookWebhookClientDiagnostics.CreateScope("AppComplianceReportWebhookCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _appComplianceReportWebhookWebhookRestClient.CreateOrUpdateAsync(Id.Name, webhookName, data, cancellationToken).ConfigureAwait(false);
                var uri = _appComplianceReportWebhookWebhookRestClient.CreateCreateOrUpdateRequestUri(Id.Name, webhookName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new AppComplianceAutomationArmOperation<AppComplianceReportWebhookResource>(Response.FromValue(new AppComplianceReportWebhookResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a new AppComplianceAutomation webhook or update an exiting AppComplianceAutomation webhook.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/webhooks/{webhookName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Webhook_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportWebhookResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="webhookName"> Webhook Name. </param>
        /// <param name="data"> Parameters for the create or update operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="webhookName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="webhookName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<AppComplianceReportWebhookResource> CreateOrUpdate(WaitUntil waitUntil, string webhookName, AppComplianceReportWebhookData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(webhookName, nameof(webhookName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _appComplianceReportWebhookWebhookClientDiagnostics.CreateScope("AppComplianceReportWebhookCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _appComplianceReportWebhookWebhookRestClient.CreateOrUpdate(Id.Name, webhookName, data, cancellationToken);
                var uri = _appComplianceReportWebhookWebhookRestClient.CreateCreateOrUpdateRequestUri(Id.Name, webhookName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new AppComplianceAutomationArmOperation<AppComplianceReportWebhookResource>(Response.FromValue(new AppComplianceReportWebhookResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the AppComplianceAutomation webhook and its properties.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/webhooks/{webhookName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Webhook_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportWebhookResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="webhookName"> Webhook Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="webhookName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="webhookName"/> is null. </exception>
        public virtual async Task<Response<AppComplianceReportWebhookResource>> GetAsync(string webhookName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(webhookName, nameof(webhookName));

            using var scope = _appComplianceReportWebhookWebhookClientDiagnostics.CreateScope("AppComplianceReportWebhookCollection.Get");
            scope.Start();
            try
            {
                var response = await _appComplianceReportWebhookWebhookRestClient.GetAsync(Id.Name, webhookName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AppComplianceReportWebhookResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the AppComplianceAutomation webhook and its properties.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/webhooks/{webhookName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Webhook_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportWebhookResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="webhookName"> Webhook Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="webhookName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="webhookName"/> is null. </exception>
        public virtual Response<AppComplianceReportWebhookResource> Get(string webhookName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(webhookName, nameof(webhookName));

            using var scope = _appComplianceReportWebhookWebhookClientDiagnostics.CreateScope("AppComplianceReportWebhookCollection.Get");
            scope.Start();
            try
            {
                var response = _appComplianceReportWebhookWebhookRestClient.Get(Id.Name, webhookName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AppComplianceReportWebhookResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the AppComplianceAutomation webhook list.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/webhooks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Webhook_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportWebhookResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="AppComplianceReportWebhookResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<AppComplianceReportWebhookResource> GetAllAsync(AppComplianceReportWebhookCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new AppComplianceReportWebhookCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _appComplianceReportWebhookWebhookRestClient.CreateListRequest(Id.Name, options.SkipToken, options.Top, options.Select, options.Filter, options.Orderby, options.OfferGuid, options.ReportCreatorTenantId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _appComplianceReportWebhookWebhookRestClient.CreateListNextPageRequest(nextLink, Id.Name, options.SkipToken, options.Top, options.Select, options.Filter, options.Orderby, options.OfferGuid, options.ReportCreatorTenantId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new AppComplianceReportWebhookResource(Client, AppComplianceReportWebhookData.DeserializeAppComplianceReportWebhookData(e)), _appComplianceReportWebhookWebhookClientDiagnostics, Pipeline, "AppComplianceReportWebhookCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Get the AppComplianceAutomation webhook list.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/webhooks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Webhook_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportWebhookResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="AppComplianceReportWebhookResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<AppComplianceReportWebhookResource> GetAll(AppComplianceReportWebhookCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new AppComplianceReportWebhookCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _appComplianceReportWebhookWebhookRestClient.CreateListRequest(Id.Name, options.SkipToken, options.Top, options.Select, options.Filter, options.Orderby, options.OfferGuid, options.ReportCreatorTenantId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _appComplianceReportWebhookWebhookRestClient.CreateListNextPageRequest(nextLink, Id.Name, options.SkipToken, options.Top, options.Select, options.Filter, options.Orderby, options.OfferGuid, options.ReportCreatorTenantId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new AppComplianceReportWebhookResource(Client, AppComplianceReportWebhookData.DeserializeAppComplianceReportWebhookData(e)), _appComplianceReportWebhookWebhookClientDiagnostics, Pipeline, "AppComplianceReportWebhookCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/webhooks/{webhookName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Webhook_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportWebhookResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="webhookName"> Webhook Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="webhookName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="webhookName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string webhookName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(webhookName, nameof(webhookName));

            using var scope = _appComplianceReportWebhookWebhookClientDiagnostics.CreateScope("AppComplianceReportWebhookCollection.Exists");
            scope.Start();
            try
            {
                var response = await _appComplianceReportWebhookWebhookRestClient.GetAsync(Id.Name, webhookName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/webhooks/{webhookName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Webhook_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportWebhookResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="webhookName"> Webhook Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="webhookName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="webhookName"/> is null. </exception>
        public virtual Response<bool> Exists(string webhookName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(webhookName, nameof(webhookName));

            using var scope = _appComplianceReportWebhookWebhookClientDiagnostics.CreateScope("AppComplianceReportWebhookCollection.Exists");
            scope.Start();
            try
            {
                var response = _appComplianceReportWebhookWebhookRestClient.Get(Id.Name, webhookName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/webhooks/{webhookName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Webhook_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportWebhookResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="webhookName"> Webhook Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="webhookName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="webhookName"/> is null. </exception>
        public virtual async Task<NullableResponse<AppComplianceReportWebhookResource>> GetIfExistsAsync(string webhookName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(webhookName, nameof(webhookName));

            using var scope = _appComplianceReportWebhookWebhookClientDiagnostics.CreateScope("AppComplianceReportWebhookCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _appComplianceReportWebhookWebhookRestClient.GetAsync(Id.Name, webhookName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<AppComplianceReportWebhookResource>(response.GetRawResponse());
                return Response.FromValue(new AppComplianceReportWebhookResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/webhooks/{webhookName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Webhook_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportWebhookResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="webhookName"> Webhook Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="webhookName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="webhookName"/> is null. </exception>
        public virtual NullableResponse<AppComplianceReportWebhookResource> GetIfExists(string webhookName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(webhookName, nameof(webhookName));

            using var scope = _appComplianceReportWebhookWebhookClientDiagnostics.CreateScope("AppComplianceReportWebhookCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _appComplianceReportWebhookWebhookRestClient.Get(Id.Name, webhookName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<AppComplianceReportWebhookResource>(response.GetRawResponse());
                return Response.FromValue(new AppComplianceReportWebhookResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<AppComplianceReportWebhookResource> IEnumerable<AppComplianceReportWebhookResource>.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IAsyncEnumerator<AppComplianceReportWebhookResource> IAsyncEnumerable<AppComplianceReportWebhookResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(options: null, cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
