// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.AppComplianceAutomation
{
    /// <summary>
    /// A class representing a collection of <see cref="AppComplianceReportScopingConfigurationResource"/> and their operations.
    /// Each <see cref="AppComplianceReportScopingConfigurationResource"/> in the collection will belong to the same instance of <see cref="AppComplianceReportResource"/>.
    /// To get an <see cref="AppComplianceReportScopingConfigurationCollection"/> instance call the GetAppComplianceReportScopingConfigurations method from an instance of <see cref="AppComplianceReportResource"/>.
    /// </summary>
    public partial class AppComplianceReportScopingConfigurationCollection : ArmCollection, IEnumerable<AppComplianceReportScopingConfigurationResource>, IAsyncEnumerable<AppComplianceReportScopingConfigurationResource>
    {
        private readonly ClientDiagnostics _appComplianceReportScopingConfigurationScopingConfigurationClientDiagnostics;
        private readonly ScopingConfigurationRestOperations _appComplianceReportScopingConfigurationScopingConfigurationRestClient;

        /// <summary> Initializes a new instance of the <see cref="AppComplianceReportScopingConfigurationCollection"/> class for mocking. </summary>
        protected AppComplianceReportScopingConfigurationCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AppComplianceReportScopingConfigurationCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal AppComplianceReportScopingConfigurationCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _appComplianceReportScopingConfigurationScopingConfigurationClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.AppComplianceAutomation", AppComplianceReportScopingConfigurationResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(AppComplianceReportScopingConfigurationResource.ResourceType, out string appComplianceReportScopingConfigurationScopingConfigurationApiVersion);
            _appComplianceReportScopingConfigurationScopingConfigurationRestClient = new ScopingConfigurationRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, appComplianceReportScopingConfigurationScopingConfigurationApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != AppComplianceReportResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, AppComplianceReportResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get the AppComplianceAutomation scoping configuration of the specific report.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/scopingConfigurations/{scopingConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ScopingConfiguration_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportScopingConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="scopingConfigurationName"> The scoping configuration of the specific report. </param>
        /// <param name="data"> Parameters for the create or update operation, this is a singleton resource, so please make sure you're using 'default' as the name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scopingConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scopingConfigurationName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<AppComplianceReportScopingConfigurationResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string scopingConfigurationName, AppComplianceReportScopingConfigurationData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scopingConfigurationName, nameof(scopingConfigurationName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _appComplianceReportScopingConfigurationScopingConfigurationClientDiagnostics.CreateScope("AppComplianceReportScopingConfigurationCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _appComplianceReportScopingConfigurationScopingConfigurationRestClient.CreateOrUpdateAsync(Id.Name, scopingConfigurationName, data, cancellationToken).ConfigureAwait(false);
                var uri = _appComplianceReportScopingConfigurationScopingConfigurationRestClient.CreateCreateOrUpdateRequestUri(Id.Name, scopingConfigurationName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new AppComplianceAutomationArmOperation<AppComplianceReportScopingConfigurationResource>(Response.FromValue(new AppComplianceReportScopingConfigurationResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the AppComplianceAutomation scoping configuration of the specific report.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/scopingConfigurations/{scopingConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ScopingConfiguration_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportScopingConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="scopingConfigurationName"> The scoping configuration of the specific report. </param>
        /// <param name="data"> Parameters for the create or update operation, this is a singleton resource, so please make sure you're using 'default' as the name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scopingConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scopingConfigurationName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<AppComplianceReportScopingConfigurationResource> CreateOrUpdate(WaitUntil waitUntil, string scopingConfigurationName, AppComplianceReportScopingConfigurationData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scopingConfigurationName, nameof(scopingConfigurationName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _appComplianceReportScopingConfigurationScopingConfigurationClientDiagnostics.CreateScope("AppComplianceReportScopingConfigurationCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _appComplianceReportScopingConfigurationScopingConfigurationRestClient.CreateOrUpdate(Id.Name, scopingConfigurationName, data, cancellationToken);
                var uri = _appComplianceReportScopingConfigurationScopingConfigurationRestClient.CreateCreateOrUpdateRequestUri(Id.Name, scopingConfigurationName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new AppComplianceAutomationArmOperation<AppComplianceReportScopingConfigurationResource>(Response.FromValue(new AppComplianceReportScopingConfigurationResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the AppComplianceAutomation scoping configuration of the specific report.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/scopingConfigurations/{scopingConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ScopingConfiguration_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportScopingConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopingConfigurationName"> The scoping configuration of the specific report. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scopingConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scopingConfigurationName"/> is null. </exception>
        public virtual async Task<Response<AppComplianceReportScopingConfigurationResource>> GetAsync(string scopingConfigurationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scopingConfigurationName, nameof(scopingConfigurationName));

            using var scope = _appComplianceReportScopingConfigurationScopingConfigurationClientDiagnostics.CreateScope("AppComplianceReportScopingConfigurationCollection.Get");
            scope.Start();
            try
            {
                var response = await _appComplianceReportScopingConfigurationScopingConfigurationRestClient.GetAsync(Id.Name, scopingConfigurationName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AppComplianceReportScopingConfigurationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the AppComplianceAutomation scoping configuration of the specific report.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/scopingConfigurations/{scopingConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ScopingConfiguration_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportScopingConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopingConfigurationName"> The scoping configuration of the specific report. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scopingConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scopingConfigurationName"/> is null. </exception>
        public virtual Response<AppComplianceReportScopingConfigurationResource> Get(string scopingConfigurationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scopingConfigurationName, nameof(scopingConfigurationName));

            using var scope = _appComplianceReportScopingConfigurationScopingConfigurationClientDiagnostics.CreateScope("AppComplianceReportScopingConfigurationCollection.Get");
            scope.Start();
            try
            {
                var response = _appComplianceReportScopingConfigurationScopingConfigurationRestClient.Get(Id.Name, scopingConfigurationName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AppComplianceReportScopingConfigurationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns a list format of the singleton scopingConfiguration for a specified report.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/scopingConfigurations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ScopingConfiguration_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportScopingConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="AppComplianceReportScopingConfigurationResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<AppComplianceReportScopingConfigurationResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _appComplianceReportScopingConfigurationScopingConfigurationRestClient.CreateListRequest(Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _appComplianceReportScopingConfigurationScopingConfigurationRestClient.CreateListNextPageRequest(nextLink, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new AppComplianceReportScopingConfigurationResource(Client, AppComplianceReportScopingConfigurationData.DeserializeAppComplianceReportScopingConfigurationData(e)), _appComplianceReportScopingConfigurationScopingConfigurationClientDiagnostics, Pipeline, "AppComplianceReportScopingConfigurationCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Returns a list format of the singleton scopingConfiguration for a specified report.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/scopingConfigurations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ScopingConfiguration_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportScopingConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="AppComplianceReportScopingConfigurationResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<AppComplianceReportScopingConfigurationResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _appComplianceReportScopingConfigurationScopingConfigurationRestClient.CreateListRequest(Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _appComplianceReportScopingConfigurationScopingConfigurationRestClient.CreateListNextPageRequest(nextLink, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new AppComplianceReportScopingConfigurationResource(Client, AppComplianceReportScopingConfigurationData.DeserializeAppComplianceReportScopingConfigurationData(e)), _appComplianceReportScopingConfigurationScopingConfigurationClientDiagnostics, Pipeline, "AppComplianceReportScopingConfigurationCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/scopingConfigurations/{scopingConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ScopingConfiguration_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportScopingConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopingConfigurationName"> The scoping configuration of the specific report. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scopingConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scopingConfigurationName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string scopingConfigurationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scopingConfigurationName, nameof(scopingConfigurationName));

            using var scope = _appComplianceReportScopingConfigurationScopingConfigurationClientDiagnostics.CreateScope("AppComplianceReportScopingConfigurationCollection.Exists");
            scope.Start();
            try
            {
                var response = await _appComplianceReportScopingConfigurationScopingConfigurationRestClient.GetAsync(Id.Name, scopingConfigurationName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/scopingConfigurations/{scopingConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ScopingConfiguration_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportScopingConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopingConfigurationName"> The scoping configuration of the specific report. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scopingConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scopingConfigurationName"/> is null. </exception>
        public virtual Response<bool> Exists(string scopingConfigurationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scopingConfigurationName, nameof(scopingConfigurationName));

            using var scope = _appComplianceReportScopingConfigurationScopingConfigurationClientDiagnostics.CreateScope("AppComplianceReportScopingConfigurationCollection.Exists");
            scope.Start();
            try
            {
                var response = _appComplianceReportScopingConfigurationScopingConfigurationRestClient.Get(Id.Name, scopingConfigurationName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/scopingConfigurations/{scopingConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ScopingConfiguration_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportScopingConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopingConfigurationName"> The scoping configuration of the specific report. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scopingConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scopingConfigurationName"/> is null. </exception>
        public virtual async Task<NullableResponse<AppComplianceReportScopingConfigurationResource>> GetIfExistsAsync(string scopingConfigurationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scopingConfigurationName, nameof(scopingConfigurationName));

            using var scope = _appComplianceReportScopingConfigurationScopingConfigurationClientDiagnostics.CreateScope("AppComplianceReportScopingConfigurationCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _appComplianceReportScopingConfigurationScopingConfigurationRestClient.GetAsync(Id.Name, scopingConfigurationName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<AppComplianceReportScopingConfigurationResource>(response.GetRawResponse());
                return Response.FromValue(new AppComplianceReportScopingConfigurationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/scopingConfigurations/{scopingConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ScopingConfiguration_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportScopingConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopingConfigurationName"> The scoping configuration of the specific report. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scopingConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scopingConfigurationName"/> is null. </exception>
        public virtual NullableResponse<AppComplianceReportScopingConfigurationResource> GetIfExists(string scopingConfigurationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scopingConfigurationName, nameof(scopingConfigurationName));

            using var scope = _appComplianceReportScopingConfigurationScopingConfigurationClientDiagnostics.CreateScope("AppComplianceReportScopingConfigurationCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _appComplianceReportScopingConfigurationScopingConfigurationRestClient.Get(Id.Name, scopingConfigurationName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<AppComplianceReportScopingConfigurationResource>(response.GetRawResponse());
                return Response.FromValue(new AppComplianceReportScopingConfigurationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<AppComplianceReportScopingConfigurationResource> IEnumerable<AppComplianceReportScopingConfigurationResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<AppComplianceReportScopingConfigurationResource> IAsyncEnumerable<AppComplianceReportScopingConfigurationResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
