// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.AppComplianceAutomation.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.AppComplianceAutomation
{
    /// <summary>
    /// A Class representing an AppComplianceReport along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct an <see cref="AppComplianceReportResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetAppComplianceReportResource method.
    /// Otherwise you can get one from its parent resource <see cref="TenantResource"/> using the GetAppComplianceReport method.
    /// </summary>
    public partial class AppComplianceReportResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="AppComplianceReportResource"/> instance. </summary>
        /// <param name="reportName"> The reportName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string reportName)
        {
            var resourceId = $"/providers/Microsoft.AppComplianceAutomation/reports/{reportName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _appComplianceReportReportClientDiagnostics;
        private readonly ReportRestOperations _appComplianceReportReportRestClient;
        private readonly AppComplianceReportData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.AppComplianceAutomation/reports";

        /// <summary> Initializes a new instance of the <see cref="AppComplianceReportResource"/> class for mocking. </summary>
        protected AppComplianceReportResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AppComplianceReportResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal AppComplianceReportResource(ArmClient client, AppComplianceReportData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="AppComplianceReportResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal AppComplianceReportResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _appComplianceReportReportClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.AppComplianceAutomation", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string appComplianceReportReportApiVersion);
            _appComplianceReportReportRestClient = new ReportRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, appComplianceReportReportApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual AppComplianceReportData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary> Gets a collection of AppComplianceReportEvidenceResources in the AppComplianceReport. </summary>
        /// <returns> An object representing collection of AppComplianceReportEvidenceResources and their operations over a AppComplianceReportEvidenceResource. </returns>
        public virtual AppComplianceReportEvidenceCollection GetAppComplianceReportEvidences()
        {
            return GetCachedClient(client => new AppComplianceReportEvidenceCollection(client, Id));
        }

        /// <summary>
        /// Get the evidence metadata
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/evidences/{evidenceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Evidence_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportEvidenceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="evidenceName"> The evidence name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="evidenceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="evidenceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<AppComplianceReportEvidenceResource>> GetAppComplianceReportEvidenceAsync(string evidenceName, CancellationToken cancellationToken = default)
        {
            return await GetAppComplianceReportEvidences().GetAsync(evidenceName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get the evidence metadata
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/evidences/{evidenceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Evidence_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportEvidenceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="evidenceName"> The evidence name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="evidenceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="evidenceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<AppComplianceReportEvidenceResource> GetAppComplianceReportEvidence(string evidenceName, CancellationToken cancellationToken = default)
        {
            return GetAppComplianceReportEvidences().Get(evidenceName, cancellationToken);
        }

        /// <summary> Gets a collection of AppComplianceReportScopingConfigurationResources in the AppComplianceReport. </summary>
        /// <returns> An object representing collection of AppComplianceReportScopingConfigurationResources and their operations over a AppComplianceReportScopingConfigurationResource. </returns>
        public virtual AppComplianceReportScopingConfigurationCollection GetAppComplianceReportScopingConfigurations()
        {
            return GetCachedClient(client => new AppComplianceReportScopingConfigurationCollection(client, Id));
        }

        /// <summary>
        /// Get the AppComplianceAutomation scoping configuration of the specific report.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/scopingConfigurations/{scopingConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ScopingConfiguration_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportScopingConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopingConfigurationName"> The scoping configuration of the specific report. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scopingConfigurationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="scopingConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<AppComplianceReportScopingConfigurationResource>> GetAppComplianceReportScopingConfigurationAsync(string scopingConfigurationName, CancellationToken cancellationToken = default)
        {
            return await GetAppComplianceReportScopingConfigurations().GetAsync(scopingConfigurationName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get the AppComplianceAutomation scoping configuration of the specific report.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/scopingConfigurations/{scopingConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ScopingConfiguration_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportScopingConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopingConfigurationName"> The scoping configuration of the specific report. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scopingConfigurationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="scopingConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<AppComplianceReportScopingConfigurationResource> GetAppComplianceReportScopingConfiguration(string scopingConfigurationName, CancellationToken cancellationToken = default)
        {
            return GetAppComplianceReportScopingConfigurations().Get(scopingConfigurationName, cancellationToken);
        }

        /// <summary> Gets a collection of AppComplianceReportSnapshotResources in the AppComplianceReport. </summary>
        /// <returns> An object representing collection of AppComplianceReportSnapshotResources and their operations over a AppComplianceReportSnapshotResource. </returns>
        public virtual AppComplianceReportSnapshotCollection GetAppComplianceReportSnapshots()
        {
            return GetCachedClient(client => new AppComplianceReportSnapshotCollection(client, Id));
        }

        /// <summary>
        /// Get the AppComplianceAutomation snapshot and its properties.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/snapshots/{snapshotName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Snapshot_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportSnapshotResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="snapshotName"> Snapshot Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="snapshotName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="snapshotName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<AppComplianceReportSnapshotResource>> GetAppComplianceReportSnapshotAsync(string snapshotName, CancellationToken cancellationToken = default)
        {
            return await GetAppComplianceReportSnapshots().GetAsync(snapshotName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get the AppComplianceAutomation snapshot and its properties.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/snapshots/{snapshotName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Snapshot_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportSnapshotResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="snapshotName"> Snapshot Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="snapshotName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="snapshotName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<AppComplianceReportSnapshotResource> GetAppComplianceReportSnapshot(string snapshotName, CancellationToken cancellationToken = default)
        {
            return GetAppComplianceReportSnapshots().Get(snapshotName, cancellationToken);
        }

        /// <summary> Gets a collection of AppComplianceReportWebhookResources in the AppComplianceReport. </summary>
        /// <returns> An object representing collection of AppComplianceReportWebhookResources and their operations over a AppComplianceReportWebhookResource. </returns>
        public virtual AppComplianceReportWebhookCollection GetAppComplianceReportWebhooks()
        {
            return GetCachedClient(client => new AppComplianceReportWebhookCollection(client, Id));
        }

        /// <summary>
        /// Get the AppComplianceAutomation webhook and its properties.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/webhooks/{webhookName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Webhook_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportWebhookResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="webhookName"> Webhook Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="webhookName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="webhookName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<AppComplianceReportWebhookResource>> GetAppComplianceReportWebhookAsync(string webhookName, CancellationToken cancellationToken = default)
        {
            return await GetAppComplianceReportWebhooks().GetAsync(webhookName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get the AppComplianceAutomation webhook and its properties.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/webhooks/{webhookName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Webhook_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportWebhookResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="webhookName"> Webhook Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="webhookName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="webhookName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<AppComplianceReportWebhookResource> GetAppComplianceReportWebhook(string webhookName, CancellationToken cancellationToken = default)
        {
            return GetAppComplianceReportWebhooks().Get(webhookName, cancellationToken);
        }

        /// <summary>
        /// Get the AppComplianceAutomation report and its properties.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Report_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<AppComplianceReportResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _appComplianceReportReportClientDiagnostics.CreateScope("AppComplianceReportResource.Get");
            scope.Start();
            try
            {
                var response = await _appComplianceReportReportRestClient.GetAsync(Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AppComplianceReportResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the AppComplianceAutomation report and its properties.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Report_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<AppComplianceReportResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _appComplianceReportReportClientDiagnostics.CreateScope("AppComplianceReportResource.Get");
            scope.Start();
            try
            {
                var response = _appComplianceReportReportRestClient.Get(Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AppComplianceReportResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Delete an AppComplianceAutomation report.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Report_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> DeleteAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _appComplianceReportReportClientDiagnostics.CreateScope("AppComplianceReportResource.Delete");
            scope.Start();
            try
            {
                var response = await _appComplianceReportReportRestClient.DeleteAsync(Id.Name, cancellationToken).ConfigureAwait(false);
                var operation = new AppComplianceAutomationArmOperation(_appComplianceReportReportClientDiagnostics, Pipeline, _appComplianceReportReportRestClient.CreateDeleteRequest(Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Delete an AppComplianceAutomation report.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Report_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Delete(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _appComplianceReportReportClientDiagnostics.CreateScope("AppComplianceReportResource.Delete");
            scope.Start();
            try
            {
                var response = _appComplianceReportReportRestClient.Delete(Id.Name, cancellationToken);
                var operation = new AppComplianceAutomationArmOperation(_appComplianceReportReportClientDiagnostics, Pipeline, _appComplianceReportReportRestClient.CreateDeleteRequest(Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Update an exiting AppComplianceAutomation report.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Report_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="patch"> Parameters for the create or update operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="patch"/> is null. </exception>
        public virtual async Task<ArmOperation<AppComplianceReportResource>> UpdateAsync(WaitUntil waitUntil, AppComplianceReportPatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(patch, nameof(patch));

            using var scope = _appComplianceReportReportClientDiagnostics.CreateScope("AppComplianceReportResource.Update");
            scope.Start();
            try
            {
                var response = await _appComplianceReportReportRestClient.UpdateAsync(Id.Name, patch, cancellationToken).ConfigureAwait(false);
                var operation = new AppComplianceAutomationArmOperation<AppComplianceReportResource>(new AppComplianceReportOperationSource(Client), _appComplianceReportReportClientDiagnostics, Pipeline, _appComplianceReportReportRestClient.CreateUpdateRequest(Id.Name, patch).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Update an exiting AppComplianceAutomation report.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Report_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="patch"> Parameters for the create or update operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="patch"/> is null. </exception>
        public virtual ArmOperation<AppComplianceReportResource> Update(WaitUntil waitUntil, AppComplianceReportPatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(patch, nameof(patch));

            using var scope = _appComplianceReportReportClientDiagnostics.CreateScope("AppComplianceReportResource.Update");
            scope.Start();
            try
            {
                var response = _appComplianceReportReportRestClient.Update(Id.Name, patch, cancellationToken);
                var operation = new AppComplianceAutomationArmOperation<AppComplianceReportResource>(new AppComplianceReportOperationSource(Client), _appComplianceReportReportClientDiagnostics, Pipeline, _appComplianceReportReportRestClient.CreateUpdateRequest(Id.Name, patch).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks the report's nested resource name availability, e.g: Webhooks, Evidences, Snapshots.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/checkNameAvailability</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Report_NestedResourceCheckNameAvailability</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> NameAvailabilityRequest object. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual async Task<Response<AppComplianceReportNameAvailabilityResult>> CheckAppComplianceReportNestedResourceNameAvailabilityAsync(AppComplianceReportNameAvailabilityContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _appComplianceReportReportClientDiagnostics.CreateScope("AppComplianceReportResource.CheckAppComplianceReportNestedResourceNameAvailability");
            scope.Start();
            try
            {
                var response = await _appComplianceReportReportRestClient.NestedResourceCheckNameAvailabilityAsync(Id.Name, content, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks the report's nested resource name availability, e.g: Webhooks, Evidences, Snapshots.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/checkNameAvailability</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Report_NestedResourceCheckNameAvailability</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> NameAvailabilityRequest object. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual Response<AppComplianceReportNameAvailabilityResult> CheckAppComplianceReportNestedResourceNameAvailability(AppComplianceReportNameAvailabilityContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _appComplianceReportReportClientDiagnostics.CreateScope("AppComplianceReportResource.CheckAppComplianceReportNestedResourceNameAvailability");
            scope.Start();
            try
            {
                var response = _appComplianceReportReportRestClient.NestedResourceCheckNameAvailability(Id.Name, content, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Fix the AppComplianceAutomation report error. e.g: App Compliance Automation Tool service unregistered, automation removed.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/fix</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Report_Fix</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation<ReportFixResult>> FixAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _appComplianceReportReportClientDiagnostics.CreateScope("AppComplianceReportResource.Fix");
            scope.Start();
            try
            {
                var response = await _appComplianceReportReportRestClient.FixAsync(Id.Name, cancellationToken).ConfigureAwait(false);
                var operation = new AppComplianceAutomationArmOperation<ReportFixResult>(new ReportFixResultOperationSource(), _appComplianceReportReportClientDiagnostics, Pipeline, _appComplianceReportReportRestClient.CreateFixRequest(Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Fix the AppComplianceAutomation report error. e.g: App Compliance Automation Tool service unregistered, automation removed.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/fix</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Report_Fix</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation<ReportFixResult> Fix(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _appComplianceReportReportClientDiagnostics.CreateScope("AppComplianceReportResource.Fix");
            scope.Start();
            try
            {
                var response = _appComplianceReportReportRestClient.Fix(Id.Name, cancellationToken);
                var operation = new AppComplianceAutomationArmOperation<ReportFixResult>(new ReportFixResultOperationSource(), _appComplianceReportReportClientDiagnostics, Pipeline, _appComplianceReportReportRestClient.CreateFixRequest(Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Fix the AppComplianceAutomation report error. e.g: App Compliance Automation Tool service unregistered, automation removed.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/getScopingQuestions</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Report_GetScopingQuestions</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ScopingQuestions>> GetScopingQuestionsAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _appComplianceReportReportClientDiagnostics.CreateScope("AppComplianceReportResource.GetScopingQuestions");
            scope.Start();
            try
            {
                var response = await _appComplianceReportReportRestClient.GetScopingQuestionsAsync(Id.Name, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Fix the AppComplianceAutomation report error. e.g: App Compliance Automation Tool service unregistered, automation removed.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/getScopingQuestions</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Report_GetScopingQuestions</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ScopingQuestions> GetScopingQuestions(CancellationToken cancellationToken = default)
        {
            using var scope = _appComplianceReportReportClientDiagnostics.CreateScope("AppComplianceReportResource.GetScopingQuestions");
            scope.Start();
            try
            {
                var response = _appComplianceReportReportRestClient.GetScopingQuestions(Id.Name, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Synchronize attestation record from app compliance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/syncCertRecord</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Report_SyncCertRecord</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="content"> Parameters for synchronize certification record operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual async Task<ArmOperation<SyncCertRecordResult>> SyncCertRecordAsync(WaitUntil waitUntil, SyncCertRecordContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _appComplianceReportReportClientDiagnostics.CreateScope("AppComplianceReportResource.SyncCertRecord");
            scope.Start();
            try
            {
                var response = await _appComplianceReportReportRestClient.SyncCertRecordAsync(Id.Name, content, cancellationToken).ConfigureAwait(false);
                var operation = new AppComplianceAutomationArmOperation<SyncCertRecordResult>(new SyncCertRecordResultOperationSource(), _appComplianceReportReportClientDiagnostics, Pipeline, _appComplianceReportReportRestClient.CreateSyncCertRecordRequest(Id.Name, content).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Synchronize attestation record from app compliance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/syncCertRecord</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Report_SyncCertRecord</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="content"> Parameters for synchronize certification record operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual ArmOperation<SyncCertRecordResult> SyncCertRecord(WaitUntil waitUntil, SyncCertRecordContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _appComplianceReportReportClientDiagnostics.CreateScope("AppComplianceReportResource.SyncCertRecord");
            scope.Start();
            try
            {
                var response = _appComplianceReportReportRestClient.SyncCertRecord(Id.Name, content, cancellationToken);
                var operation = new AppComplianceAutomationArmOperation<SyncCertRecordResult>(new SyncCertRecordResultOperationSource(), _appComplianceReportReportClientDiagnostics, Pipeline, _appComplianceReportReportRestClient.CreateSyncCertRecordRequest(Id.Name, content).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Verify the AppComplianceAutomation report health status.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/verify</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Report_Verify</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation<ReportVerificationResult>> VerifyAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _appComplianceReportReportClientDiagnostics.CreateScope("AppComplianceReportResource.Verify");
            scope.Start();
            try
            {
                var response = await _appComplianceReportReportRestClient.VerifyAsync(Id.Name, cancellationToken).ConfigureAwait(false);
                var operation = new AppComplianceAutomationArmOperation<ReportVerificationResult>(new ReportVerificationResultOperationSource(), _appComplianceReportReportClientDiagnostics, Pipeline, _appComplianceReportReportRestClient.CreateVerifyRequest(Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Verify the AppComplianceAutomation report health status.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/verify</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Report_Verify</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation<ReportVerificationResult> Verify(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _appComplianceReportReportClientDiagnostics.CreateScope("AppComplianceReportResource.Verify");
            scope.Start();
            try
            {
                var response = _appComplianceReportReportRestClient.Verify(Id.Name, cancellationToken);
                var operation = new AppComplianceAutomationArmOperation<ReportVerificationResult>(new ReportVerificationResultOperationSource(), _appComplianceReportReportClientDiagnostics, Pipeline, _appComplianceReportReportRestClient.CreateVerifyRequest(Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
