// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.AppComplianceAutomation.Models;

namespace Azure.ResourceManager.AppComplianceAutomation
{
    /// <summary>
    /// A Class representing an AppComplianceReportEvidence along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct an <see cref="AppComplianceReportEvidenceResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetAppComplianceReportEvidenceResource method.
    /// Otherwise you can get one from its parent resource <see cref="AppComplianceReportResource"/> using the GetAppComplianceReportEvidence method.
    /// </summary>
    public partial class AppComplianceReportEvidenceResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="AppComplianceReportEvidenceResource"/> instance. </summary>
        /// <param name="reportName"> The reportName. </param>
        /// <param name="evidenceName"> The evidenceName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string reportName, string evidenceName)
        {
            var resourceId = $"/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/evidences/{evidenceName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _appComplianceReportEvidenceEvidenceClientDiagnostics;
        private readonly EvidenceRestOperations _appComplianceReportEvidenceEvidenceRestClient;
        private readonly AppComplianceReportEvidenceData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.AppComplianceAutomation/reports/evidences";

        /// <summary> Initializes a new instance of the <see cref="AppComplianceReportEvidenceResource"/> class for mocking. </summary>
        protected AppComplianceReportEvidenceResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AppComplianceReportEvidenceResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal AppComplianceReportEvidenceResource(ArmClient client, AppComplianceReportEvidenceData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="AppComplianceReportEvidenceResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal AppComplianceReportEvidenceResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _appComplianceReportEvidenceEvidenceClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.AppComplianceAutomation", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string appComplianceReportEvidenceEvidenceApiVersion);
            _appComplianceReportEvidenceEvidenceRestClient = new EvidenceRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, appComplianceReportEvidenceEvidenceApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual AppComplianceReportEvidenceData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Get the evidence metadata
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/evidences/{evidenceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Evidence_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportEvidenceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<AppComplianceReportEvidenceResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _appComplianceReportEvidenceEvidenceClientDiagnostics.CreateScope("AppComplianceReportEvidenceResource.Get");
            scope.Start();
            try
            {
                var response = await _appComplianceReportEvidenceEvidenceRestClient.GetAsync(Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AppComplianceReportEvidenceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the evidence metadata
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/evidences/{evidenceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Evidence_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportEvidenceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<AppComplianceReportEvidenceResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _appComplianceReportEvidenceEvidenceClientDiagnostics.CreateScope("AppComplianceReportEvidenceResource.Get");
            scope.Start();
            try
            {
                var response = _appComplianceReportEvidenceEvidenceRestClient.Get(Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AppComplianceReportEvidenceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Delete an existent evidence from a specified report
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/evidences/{evidenceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Evidence_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportEvidenceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> DeleteAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _appComplianceReportEvidenceEvidenceClientDiagnostics.CreateScope("AppComplianceReportEvidenceResource.Delete");
            scope.Start();
            try
            {
                var response = await _appComplianceReportEvidenceEvidenceRestClient.DeleteAsync(Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                var uri = _appComplianceReportEvidenceEvidenceRestClient.CreateDeleteRequestUri(Id.Parent.Name, Id.Name);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Delete, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new AppComplianceAutomationArmOperation(response, rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Delete an existent evidence from a specified report
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/evidences/{evidenceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Evidence_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportEvidenceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Delete(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _appComplianceReportEvidenceEvidenceClientDiagnostics.CreateScope("AppComplianceReportEvidenceResource.Delete");
            scope.Start();
            try
            {
                var response = _appComplianceReportEvidenceEvidenceRestClient.Delete(Id.Parent.Name, Id.Name, cancellationToken);
                var uri = _appComplianceReportEvidenceEvidenceRestClient.CreateDeleteRequestUri(Id.Parent.Name, Id.Name);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Delete, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new AppComplianceAutomationArmOperation(response, rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create or Update an evidence a specified report
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/evidences/{evidenceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Evidence_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportEvidenceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> Parameters for the create or update operation. </param>
        /// <param name="offerGuid"> The offerGuid which mapping to the reports. </param>
        /// <param name="reportCreatorTenantId"> The tenant id of the report creator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<AppComplianceReportEvidenceResource>> UpdateAsync(WaitUntil waitUntil, AppComplianceReportEvidenceData data, string offerGuid = null, string reportCreatorTenantId = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _appComplianceReportEvidenceEvidenceClientDiagnostics.CreateScope("AppComplianceReportEvidenceResource.Update");
            scope.Start();
            try
            {
                var response = await _appComplianceReportEvidenceEvidenceRestClient.CreateOrUpdateAsync(Id.Parent.Name, Id.Name, data, offerGuid, reportCreatorTenantId, cancellationToken).ConfigureAwait(false);
                var uri = _appComplianceReportEvidenceEvidenceRestClient.CreateCreateOrUpdateRequestUri(Id.Parent.Name, Id.Name, data, offerGuid, reportCreatorTenantId);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new AppComplianceAutomationArmOperation<AppComplianceReportEvidenceResource>(Response.FromValue(new AppComplianceReportEvidenceResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create or Update an evidence a specified report
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/evidences/{evidenceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Evidence_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportEvidenceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> Parameters for the create or update operation. </param>
        /// <param name="offerGuid"> The offerGuid which mapping to the reports. </param>
        /// <param name="reportCreatorTenantId"> The tenant id of the report creator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<AppComplianceReportEvidenceResource> Update(WaitUntil waitUntil, AppComplianceReportEvidenceData data, string offerGuid = null, string reportCreatorTenantId = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _appComplianceReportEvidenceEvidenceClientDiagnostics.CreateScope("AppComplianceReportEvidenceResource.Update");
            scope.Start();
            try
            {
                var response = _appComplianceReportEvidenceEvidenceRestClient.CreateOrUpdate(Id.Parent.Name, Id.Name, data, offerGuid, reportCreatorTenantId, cancellationToken);
                var uri = _appComplianceReportEvidenceEvidenceRestClient.CreateCreateOrUpdateRequestUri(Id.Parent.Name, Id.Name, data, offerGuid, reportCreatorTenantId);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new AppComplianceAutomationArmOperation<AppComplianceReportEvidenceResource>(Response.FromValue(new AppComplianceReportEvidenceResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Download evidence file.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/evidences/{evidenceName}/download</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Evidence_Download</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportEvidenceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> Parameters for the query operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual async Task<Response<EvidenceFileDownloadResult>> DownloadAsync(EvidenceFileDownloadRequestContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _appComplianceReportEvidenceEvidenceClientDiagnostics.CreateScope("AppComplianceReportEvidenceResource.Download");
            scope.Start();
            try
            {
                var response = await _appComplianceReportEvidenceEvidenceRestClient.DownloadAsync(Id.Parent.Name, Id.Name, content, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Download evidence file.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/evidences/{evidenceName}/download</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Evidence_Download</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-27</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppComplianceReportEvidenceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> Parameters for the query operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual Response<EvidenceFileDownloadResult> Download(EvidenceFileDownloadRequestContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _appComplianceReportEvidenceEvidenceClientDiagnostics.CreateScope("AppComplianceReportEvidenceResource.Download");
            scope.Start();
            try
            {
                var response = _appComplianceReportEvidenceEvidenceRestClient.Download(Id.Parent.Name, Id.Name, content, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
