// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.AppComplianceAutomation.Models;

namespace Azure.ResourceManager.AppComplianceAutomation.Samples
{
    public partial class Sample_TenantResourceExtensions
    {
        // Report_CheckNameAvailability
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CheckAppComplianceReportNameAvailability_ReportCheckNameAvailability()
        {
            // Generated from example definition: specification/appcomplianceautomation/resource-manager/Microsoft.AppComplianceAutomation/stable/2024-06-27/examples/Report_CheckNameAvailability.json
            // this example is just showing the usage of "ProviderActions_CheckNameAvailability" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            AppComplianceReportNameAvailabilityContent content = new AppComplianceReportNameAvailabilityContent();
            AppComplianceReportNameAvailabilityResult result = await tenantResource.CheckAppComplianceReportNameAvailabilityAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Report_GetCollectionCount
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetCollectionCountProviderAction_ReportGetCollectionCount()
        {
            // Generated from example definition: specification/appcomplianceautomation/resource-manager/Microsoft.AppComplianceAutomation/stable/2024-06-27/examples/Report_GetCollectionCount.json
            // this example is just showing the usage of "ProviderActions_GetCollectionCount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            ReportCollectionGetCountContent content = new ReportCollectionGetCountContent();
            ReportCollectionGetCountResult result = await tenantResource.GetCollectionCountProviderActionAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Report_GetOverviewStatus
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetOverviewStatusProviderAction_ReportGetOverviewStatus()
        {
            // Generated from example definition: specification/appcomplianceautomation/resource-manager/Microsoft.AppComplianceAutomation/stable/2024-06-27/examples/Report_GetOverviewStatus.json
            // this example is just showing the usage of "ProviderActions_GetOverviewStatus" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            AppComplianceGetOverviewStatusContent content = new AppComplianceGetOverviewStatusContent();
            AppComplianceGetOverviewStatusResult result = await tenantResource.GetOverviewStatusProviderActionAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ListInUseStorageAccountsWithSubscriptions
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetInUseStorageAccountsProviderAction_ListInUseStorageAccountsWithSubscriptions()
        {
            // Generated from example definition: specification/appcomplianceautomation/resource-manager/Microsoft.AppComplianceAutomation/stable/2024-06-27/examples/ListInUseStorageAccountsWithSubscriptions.json
            // this example is just showing the usage of "ProviderActions_ListInUseStorageAccounts" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            ReportListInUseStorageAccountsContent content = new ReportListInUseStorageAccountsContent();
            ReportListInUseStorageAccountsResult result = await tenantResource.GetInUseStorageAccountsProviderActionAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ListInUseStorageAccountsWithoutSubscriptions
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetInUseStorageAccountsProviderAction_ListInUseStorageAccountsWithoutSubscriptions()
        {
            // Generated from example definition: specification/appcomplianceautomation/resource-manager/Microsoft.AppComplianceAutomation/stable/2024-06-27/examples/ListInUseStorageAccountsWithoutSubscriptions.json
            // this example is just showing the usage of "ProviderActions_ListInUseStorageAccounts" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            ReportListInUseStorageAccountsContent content = new ReportListInUseStorageAccountsContent();
            ReportListInUseStorageAccountsResult result = await tenantResource.GetInUseStorageAccountsProviderActionAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Onboard
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task OnboardProviderAction_Onboard()
        {
            // Generated from example definition: specification/appcomplianceautomation/resource-manager/Microsoft.AppComplianceAutomation/stable/2024-06-27/examples/Onboard.json
            // this example is just showing the usage of "ProviderActions_Onboard" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            AppComplianceOnboardContent content = new AppComplianceOnboardContent(new string[]
            {
            });
            ArmOperation<AppComplianceOnboardResult> lro = await tenantResource.OnboardProviderActionAsync(WaitUntil.Completed, content);
            AppComplianceOnboardResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // TriggerEvaluation
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task TriggerEvaluationProviderAction_TriggerEvaluation()
        {
            // Generated from example definition: specification/appcomplianceautomation/resource-manager/Microsoft.AppComplianceAutomation/stable/2024-06-27/examples/TriggerEvaluation.json
            // this example is just showing the usage of "ProviderActions_TriggerEvaluation" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            TriggerEvaluationContent content = new TriggerEvaluationContent(new string[]
            {
            });
            ArmOperation<TriggerEvaluationResult> lro = await tenantResource.TriggerEvaluationProviderActionAsync(WaitUntil.Completed, content);
            TriggerEvaluationResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
