// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.AppComplianceAutomation.Models;

namespace Azure.ResourceManager.AppComplianceAutomation.Samples
{
    public partial class Sample_AppComplianceReportWebhookResource
    {
        // Webhook_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_WebhookGet()
        {
            // Generated from example definition: specification/appcomplianceautomation/resource-manager/Microsoft.AppComplianceAutomation/stable/2024-06-27/examples/Webhook_Get.json
            // this example is just showing the usage of "Webhook_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppComplianceReportWebhookResource created on azure
            // for more information of creating AppComplianceReportWebhookResource, please refer to the document of AppComplianceReportWebhookResource
            string reportName = "testReportName";
            string webhookName = "testWebhookName";
            ResourceIdentifier appComplianceReportWebhookResourceId = AppComplianceReportWebhookResource.CreateResourceIdentifier(reportName, webhookName);
            AppComplianceReportWebhookResource appComplianceReportWebhook = client.GetAppComplianceReportWebhookResource(appComplianceReportWebhookResourceId);

            // invoke the operation
            AppComplianceReportWebhookResource result = await appComplianceReportWebhook.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AppComplianceReportWebhookData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Webhook_Update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_WebhookUpdate()
        {
            // Generated from example definition: specification/appcomplianceautomation/resource-manager/Microsoft.AppComplianceAutomation/stable/2024-06-27/examples/Webhook_Update.json
            // this example is just showing the usage of "Webhook_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppComplianceReportWebhookResource created on azure
            // for more information of creating AppComplianceReportWebhookResource, please refer to the document of AppComplianceReportWebhookResource
            string reportName = "testReportName";
            string webhookName = "testWebhookName";
            ResourceIdentifier appComplianceReportWebhookResourceId = AppComplianceReportWebhookResource.CreateResourceIdentifier(reportName, webhookName);
            AppComplianceReportWebhookResource appComplianceReportWebhook = client.GetAppComplianceReportWebhookResource(appComplianceReportWebhookResourceId);

            // invoke the operation
            AppComplianceReportWebhookPatch patch = new AppComplianceReportWebhookPatch();
            AppComplianceReportWebhookResource result = await appComplianceReportWebhook.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AppComplianceReportWebhookData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Webhook_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_WebhookDelete()
        {
            // Generated from example definition: specification/appcomplianceautomation/resource-manager/Microsoft.AppComplianceAutomation/stable/2024-06-27/examples/Webhook_Delete.json
            // this example is just showing the usage of "Webhook_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppComplianceReportWebhookResource created on azure
            // for more information of creating AppComplianceReportWebhookResource, please refer to the document of AppComplianceReportWebhookResource
            string reportName = "testReportName";
            string webhookName = "testWebhookName";
            ResourceIdentifier appComplianceReportWebhookResourceId = AppComplianceReportWebhookResource.CreateResourceIdentifier(reportName, webhookName);
            AppComplianceReportWebhookResource appComplianceReportWebhook = client.GetAppComplianceReportWebhookResource(appComplianceReportWebhookResourceId);

            // invoke the operation
            await appComplianceReportWebhook.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
