// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.AppComplianceAutomation.Models;

namespace Azure.ResourceManager.AppComplianceAutomation.Samples
{
    public partial class Sample_AppComplianceReportEvidenceCollection
    {
        // Evidence_ListByReport
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_EvidenceListByReport()
        {
            // Generated from example definition: specification/appcomplianceautomation/resource-manager/Microsoft.AppComplianceAutomation/stable/2024-06-27/examples/Evidence_ListByReport.json
            // this example is just showing the usage of "Evidence_ListByReport" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppComplianceReportResource created on azure
            // for more information of creating AppComplianceReportResource, please refer to the document of AppComplianceReportResource
            string reportName = "reportName";
            ResourceIdentifier appComplianceReportResourceId = AppComplianceReportResource.CreateResourceIdentifier(reportName);
            AppComplianceReportResource appComplianceReport = client.GetAppComplianceReportResource(appComplianceReportResourceId);

            // get the collection of this AppComplianceReportEvidenceResource
            AppComplianceReportEvidenceCollection collection = appComplianceReport.GetAppComplianceReportEvidences();

            // invoke the operation and iterate over the result
            AppComplianceReportEvidenceCollectionGetAllOptions options = new AppComplianceReportEvidenceCollectionGetAllOptions() { };
            await foreach (AppComplianceReportEvidenceResource item in collection.GetAllAsync(options))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AppComplianceReportEvidenceData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Evidence_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_EvidenceGet()
        {
            // Generated from example definition: specification/appcomplianceautomation/resource-manager/Microsoft.AppComplianceAutomation/stable/2024-06-27/examples/Evidence_Get.json
            // this example is just showing the usage of "Evidence_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppComplianceReportResource created on azure
            // for more information of creating AppComplianceReportResource, please refer to the document of AppComplianceReportResource
            string reportName = "testReportName";
            ResourceIdentifier appComplianceReportResourceId = AppComplianceReportResource.CreateResourceIdentifier(reportName);
            AppComplianceReportResource appComplianceReport = client.GetAppComplianceReportResource(appComplianceReportResourceId);

            // get the collection of this AppComplianceReportEvidenceResource
            AppComplianceReportEvidenceCollection collection = appComplianceReport.GetAppComplianceReportEvidences();

            // invoke the operation
            string evidenceName = "evidence1";
            AppComplianceReportEvidenceResource result = await collection.GetAsync(evidenceName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AppComplianceReportEvidenceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Evidence_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_EvidenceGet()
        {
            // Generated from example definition: specification/appcomplianceautomation/resource-manager/Microsoft.AppComplianceAutomation/stable/2024-06-27/examples/Evidence_Get.json
            // this example is just showing the usage of "Evidence_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppComplianceReportResource created on azure
            // for more information of creating AppComplianceReportResource, please refer to the document of AppComplianceReportResource
            string reportName = "testReportName";
            ResourceIdentifier appComplianceReportResourceId = AppComplianceReportResource.CreateResourceIdentifier(reportName);
            AppComplianceReportResource appComplianceReport = client.GetAppComplianceReportResource(appComplianceReportResourceId);

            // get the collection of this AppComplianceReportEvidenceResource
            AppComplianceReportEvidenceCollection collection = appComplianceReport.GetAppComplianceReportEvidences();

            // invoke the operation
            string evidenceName = "evidence1";
            bool result = await collection.ExistsAsync(evidenceName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Evidence_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_EvidenceGet()
        {
            // Generated from example definition: specification/appcomplianceautomation/resource-manager/Microsoft.AppComplianceAutomation/stable/2024-06-27/examples/Evidence_Get.json
            // this example is just showing the usage of "Evidence_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppComplianceReportResource created on azure
            // for more information of creating AppComplianceReportResource, please refer to the document of AppComplianceReportResource
            string reportName = "testReportName";
            ResourceIdentifier appComplianceReportResourceId = AppComplianceReportResource.CreateResourceIdentifier(reportName);
            AppComplianceReportResource appComplianceReport = client.GetAppComplianceReportResource(appComplianceReportResourceId);

            // get the collection of this AppComplianceReportEvidenceResource
            AppComplianceReportEvidenceCollection collection = appComplianceReport.GetAppComplianceReportEvidences();

            // invoke the operation
            string evidenceName = "evidence1";
            NullableResponse<AppComplianceReportEvidenceResource> response = await collection.GetIfExistsAsync(evidenceName);
            AppComplianceReportEvidenceResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AppComplianceReportEvidenceData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
