// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.ApiManagement
{
    /// <summary>
    /// A class representing a collection of <see cref="WorkspaceContractResource"/> and their operations.
    /// Each <see cref="WorkspaceContractResource"/> in the collection will belong to the same instance of <see cref="ApiManagementServiceResource"/>.
    /// To get a <see cref="WorkspaceContractCollection"/> instance call the GetWorkspaceContracts method from an instance of <see cref="ApiManagementServiceResource"/>.
    /// </summary>
    public partial class WorkspaceContractCollection : ArmCollection, IEnumerable<WorkspaceContractResource>, IAsyncEnumerable<WorkspaceContractResource>
    {
        private readonly ClientDiagnostics _workspaceContractWorkspaceClientDiagnostics;
        private readonly WorkspaceRestOperations _workspaceContractWorkspaceRestClient;

        /// <summary> Initializes a new instance of the <see cref="WorkspaceContractCollection"/> class for mocking. </summary>
        protected WorkspaceContractCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="WorkspaceContractCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal WorkspaceContractCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _workspaceContractWorkspaceClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApiManagement", WorkspaceContractResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(WorkspaceContractResource.ResourceType, out string workspaceContractWorkspaceApiVersion);
            _workspaceContractWorkspaceRestClient = new WorkspaceRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, workspaceContractWorkspaceApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ApiManagementServiceResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ApiManagementServiceResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates a new workspace or updates an existing one.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspace_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="workspaceId"> Workspace identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="data"> Create parameters. </param>
        /// <param name="ifMatch"> ETag of the Entity. Not required when creating an entity, but required when updating an entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceId"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<WorkspaceContractResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string workspaceId, WorkspaceContractData data, ETag? ifMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceId, nameof(workspaceId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _workspaceContractWorkspaceClientDiagnostics.CreateScope("WorkspaceContractCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _workspaceContractWorkspaceRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceId, data, ifMatch, cancellationToken).ConfigureAwait(false);
                var uri = _workspaceContractWorkspaceRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceId, data, ifMatch);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ApiManagementArmOperation<WorkspaceContractResource>(Response.FromValue(new WorkspaceContractResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates a new workspace or updates an existing one.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspace_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="workspaceId"> Workspace identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="data"> Create parameters. </param>
        /// <param name="ifMatch"> ETag of the Entity. Not required when creating an entity, but required when updating an entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceId"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<WorkspaceContractResource> CreateOrUpdate(WaitUntil waitUntil, string workspaceId, WorkspaceContractData data, ETag? ifMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceId, nameof(workspaceId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _workspaceContractWorkspaceClientDiagnostics.CreateScope("WorkspaceContractCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _workspaceContractWorkspaceRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceId, data, ifMatch, cancellationToken);
                var uri = _workspaceContractWorkspaceRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceId, data, ifMatch);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ApiManagementArmOperation<WorkspaceContractResource>(Response.FromValue(new WorkspaceContractResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the details of the workspace specified by its identifier.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspace_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> Workspace identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceId"/> is null. </exception>
        public virtual async Task<Response<WorkspaceContractResource>> GetAsync(string workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceId, nameof(workspaceId));

            using var scope = _workspaceContractWorkspaceClientDiagnostics.CreateScope("WorkspaceContractCollection.Get");
            scope.Start();
            try
            {
                var response = await _workspaceContractWorkspaceRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new WorkspaceContractResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the details of the workspace specified by its identifier.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspace_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> Workspace identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceId"/> is null. </exception>
        public virtual Response<WorkspaceContractResource> Get(string workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceId, nameof(workspaceId));

            using var scope = _workspaceContractWorkspaceClientDiagnostics.CreateScope("WorkspaceContractCollection.Get");
            scope.Start();
            try
            {
                var response = _workspaceContractWorkspaceRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new WorkspaceContractResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists all workspaces of the API Management service instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspace_ListByService</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> |     Field     |     Usage     |     Supported operators     |     Supported functions     |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;&lt;/br&gt;| description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;. </param>
        /// <param name="top"> Number of records to return. </param>
        /// <param name="skip"> Number of records to skip. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="WorkspaceContractResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<WorkspaceContractResource> GetAllAsync(string filter = null, int? top = null, int? skip = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _workspaceContractWorkspaceRestClient.CreateListByServiceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, top, skip);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _workspaceContractWorkspaceRestClient.CreateListByServiceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, top, skip);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new WorkspaceContractResource(Client, WorkspaceContractData.DeserializeWorkspaceContractData(e)), _workspaceContractWorkspaceClientDiagnostics, Pipeline, "WorkspaceContractCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists all workspaces of the API Management service instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspace_ListByService</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> |     Field     |     Usage     |     Supported operators     |     Supported functions     |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;&lt;/br&gt;| description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;. </param>
        /// <param name="top"> Number of records to return. </param>
        /// <param name="skip"> Number of records to skip. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="WorkspaceContractResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<WorkspaceContractResource> GetAll(string filter = null, int? top = null, int? skip = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _workspaceContractWorkspaceRestClient.CreateListByServiceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, top, skip);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _workspaceContractWorkspaceRestClient.CreateListByServiceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, top, skip);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new WorkspaceContractResource(Client, WorkspaceContractData.DeserializeWorkspaceContractData(e)), _workspaceContractWorkspaceClientDiagnostics, Pipeline, "WorkspaceContractCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspace_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> Workspace identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceId, nameof(workspaceId));

            using var scope = _workspaceContractWorkspaceClientDiagnostics.CreateScope("WorkspaceContractCollection.Exists");
            scope.Start();
            try
            {
                var response = await _workspaceContractWorkspaceRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspace_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> Workspace identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceId"/> is null. </exception>
        public virtual Response<bool> Exists(string workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceId, nameof(workspaceId));

            using var scope = _workspaceContractWorkspaceClientDiagnostics.CreateScope("WorkspaceContractCollection.Exists");
            scope.Start();
            try
            {
                var response = _workspaceContractWorkspaceRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspace_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> Workspace identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceId"/> is null. </exception>
        public virtual async Task<NullableResponse<WorkspaceContractResource>> GetIfExistsAsync(string workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceId, nameof(workspaceId));

            using var scope = _workspaceContractWorkspaceClientDiagnostics.CreateScope("WorkspaceContractCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _workspaceContractWorkspaceRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<WorkspaceContractResource>(response.GetRawResponse());
                return Response.FromValue(new WorkspaceContractResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspace_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> Workspace identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceId"/> is null. </exception>
        public virtual NullableResponse<WorkspaceContractResource> GetIfExists(string workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceId, nameof(workspaceId));

            using var scope = _workspaceContractWorkspaceClientDiagnostics.CreateScope("WorkspaceContractCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _workspaceContractWorkspaceRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<WorkspaceContractResource>(response.GetRawResponse());
                return Response.FromValue(new WorkspaceContractResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<WorkspaceContractResource> IEnumerable<WorkspaceContractResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<WorkspaceContractResource> IAsyncEnumerable<WorkspaceContractResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
