// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.ApiManagement
{
    /// <summary>
    /// A class representing a collection of <see cref="ServiceWorkspaceTagProductLinkResource"/> and their operations.
    /// Each <see cref="ServiceWorkspaceTagProductLinkResource"/> in the collection will belong to the same instance of <see cref="ServiceWorkspaceTagResource"/>.
    /// To get a <see cref="ServiceWorkspaceTagProductLinkCollection"/> instance call the GetServiceWorkspaceTagProductLinks method from an instance of <see cref="ServiceWorkspaceTagResource"/>.
    /// </summary>
    public partial class ServiceWorkspaceTagProductLinkCollection : ArmCollection, IEnumerable<ServiceWorkspaceTagProductLinkResource>, IAsyncEnumerable<ServiceWorkspaceTagProductLinkResource>
    {
        private readonly ClientDiagnostics _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkClientDiagnostics;
        private readonly WorkspaceTagProductLinkRestOperations _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkRestClient;

        /// <summary> Initializes a new instance of the <see cref="ServiceWorkspaceTagProductLinkCollection"/> class for mocking. </summary>
        protected ServiceWorkspaceTagProductLinkCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ServiceWorkspaceTagProductLinkCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ServiceWorkspaceTagProductLinkCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApiManagement", ServiceWorkspaceTagProductLinkResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ServiceWorkspaceTagProductLinkResource.ResourceType, out string serviceWorkspaceTagProductLinkWorkspaceTagProductLinkApiVersion);
            _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkRestClient = new WorkspaceTagProductLinkRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, serviceWorkspaceTagProductLinkWorkspaceTagProductLinkApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ServiceWorkspaceTagResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ServiceWorkspaceTagResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Adds a product to the specified tag via link.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/tags/{tagId}/productLinks/{productLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceTagProductLink_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="productLinkId"> Tag-product link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="data"> Create or update parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productLinkId"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ServiceWorkspaceTagProductLinkResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string productLinkId, TagProductLinkContractData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productLinkId, nameof(productLinkId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkClientDiagnostics.CreateScope("ServiceWorkspaceTagProductLinkCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, productLinkId, data, cancellationToken).ConfigureAwait(false);
                var uri = _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, productLinkId, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ApiManagementArmOperation<ServiceWorkspaceTagProductLinkResource>(Response.FromValue(new ServiceWorkspaceTagProductLinkResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Adds a product to the specified tag via link.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/tags/{tagId}/productLinks/{productLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceTagProductLink_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="productLinkId"> Tag-product link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="data"> Create or update parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productLinkId"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ServiceWorkspaceTagProductLinkResource> CreateOrUpdate(WaitUntil waitUntil, string productLinkId, TagProductLinkContractData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productLinkId, nameof(productLinkId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkClientDiagnostics.CreateScope("ServiceWorkspaceTagProductLinkCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, productLinkId, data, cancellationToken);
                var uri = _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, productLinkId, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ApiManagementArmOperation<ServiceWorkspaceTagProductLinkResource>(Response.FromValue(new ServiceWorkspaceTagProductLinkResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the product link for the tag.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/tags/{tagId}/productLinks/{productLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceTagProductLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productLinkId"> Tag-product link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productLinkId"/> is null. </exception>
        public virtual async Task<Response<ServiceWorkspaceTagProductLinkResource>> GetAsync(string productLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productLinkId, nameof(productLinkId));

            using var scope = _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkClientDiagnostics.CreateScope("ServiceWorkspaceTagProductLinkCollection.Get");
            scope.Start();
            try
            {
                var response = await _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, productLinkId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServiceWorkspaceTagProductLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the product link for the tag.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/tags/{tagId}/productLinks/{productLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceTagProductLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productLinkId"> Tag-product link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productLinkId"/> is null. </exception>
        public virtual Response<ServiceWorkspaceTagProductLinkResource> Get(string productLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productLinkId, nameof(productLinkId));

            using var scope = _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkClientDiagnostics.CreateScope("ServiceWorkspaceTagProductLinkCollection.Get");
            scope.Start();
            try
            {
                var response = _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, productLinkId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServiceWorkspaceTagProductLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists a collection of the product links associated with a tag.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/tags/{tagId}/productLinks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceTagProductLink_ListByProduct</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> |     Field     |     Usage     |     Supported operators     |     Supported functions     |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| productId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;. </param>
        /// <param name="top"> Number of records to return. </param>
        /// <param name="skip"> Number of records to skip. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ServiceWorkspaceTagProductLinkResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ServiceWorkspaceTagProductLinkResource> GetAllAsync(string filter = null, int? top = null, int? skip = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkRestClient.CreateListByProductRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, filter, top, skip);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkRestClient.CreateListByProductNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, filter, top, skip);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ServiceWorkspaceTagProductLinkResource(Client, TagProductLinkContractData.DeserializeTagProductLinkContractData(e)), _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkClientDiagnostics, Pipeline, "ServiceWorkspaceTagProductLinkCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists a collection of the product links associated with a tag.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/tags/{tagId}/productLinks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceTagProductLink_ListByProduct</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> |     Field     |     Usage     |     Supported operators     |     Supported functions     |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| productId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;. </param>
        /// <param name="top"> Number of records to return. </param>
        /// <param name="skip"> Number of records to skip. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ServiceWorkspaceTagProductLinkResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ServiceWorkspaceTagProductLinkResource> GetAll(string filter = null, int? top = null, int? skip = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkRestClient.CreateListByProductRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, filter, top, skip);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkRestClient.CreateListByProductNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, filter, top, skip);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ServiceWorkspaceTagProductLinkResource(Client, TagProductLinkContractData.DeserializeTagProductLinkContractData(e)), _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkClientDiagnostics, Pipeline, "ServiceWorkspaceTagProductLinkCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/tags/{tagId}/productLinks/{productLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceTagProductLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productLinkId"> Tag-product link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productLinkId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string productLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productLinkId, nameof(productLinkId));

            using var scope = _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkClientDiagnostics.CreateScope("ServiceWorkspaceTagProductLinkCollection.Exists");
            scope.Start();
            try
            {
                var response = await _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, productLinkId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/tags/{tagId}/productLinks/{productLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceTagProductLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productLinkId"> Tag-product link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productLinkId"/> is null. </exception>
        public virtual Response<bool> Exists(string productLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productLinkId, nameof(productLinkId));

            using var scope = _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkClientDiagnostics.CreateScope("ServiceWorkspaceTagProductLinkCollection.Exists");
            scope.Start();
            try
            {
                var response = _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, productLinkId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/tags/{tagId}/productLinks/{productLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceTagProductLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productLinkId"> Tag-product link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productLinkId"/> is null. </exception>
        public virtual async Task<NullableResponse<ServiceWorkspaceTagProductLinkResource>> GetIfExistsAsync(string productLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productLinkId, nameof(productLinkId));

            using var scope = _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkClientDiagnostics.CreateScope("ServiceWorkspaceTagProductLinkCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, productLinkId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ServiceWorkspaceTagProductLinkResource>(response.GetRawResponse());
                return Response.FromValue(new ServiceWorkspaceTagProductLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/tags/{tagId}/productLinks/{productLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceTagProductLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productLinkId"> Tag-product link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productLinkId"/> is null. </exception>
        public virtual NullableResponse<ServiceWorkspaceTagProductLinkResource> GetIfExists(string productLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productLinkId, nameof(productLinkId));

            using var scope = _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkClientDiagnostics.CreateScope("ServiceWorkspaceTagProductLinkCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _serviceWorkspaceTagProductLinkWorkspaceTagProductLinkRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, productLinkId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ServiceWorkspaceTagProductLinkResource>(response.GetRawResponse());
                return Response.FromValue(new ServiceWorkspaceTagProductLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ServiceWorkspaceTagProductLinkResource> IEnumerable<ServiceWorkspaceTagProductLinkResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ServiceWorkspaceTagProductLinkResource> IAsyncEnumerable<ServiceWorkspaceTagProductLinkResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
