// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.ApiManagement
{
    /// <summary>
    /// A class representing a collection of <see cref="ServiceWorkspaceProductGroupLinkResource"/> and their operations.
    /// Each <see cref="ServiceWorkspaceProductGroupLinkResource"/> in the collection will belong to the same instance of <see cref="ServiceWorkspaceProductResource"/>.
    /// To get a <see cref="ServiceWorkspaceProductGroupLinkCollection"/> instance call the GetServiceWorkspaceProductGroupLinks method from an instance of <see cref="ServiceWorkspaceProductResource"/>.
    /// </summary>
    public partial class ServiceWorkspaceProductGroupLinkCollection : ArmCollection, IEnumerable<ServiceWorkspaceProductGroupLinkResource>, IAsyncEnumerable<ServiceWorkspaceProductGroupLinkResource>
    {
        private readonly ClientDiagnostics _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkClientDiagnostics;
        private readonly WorkspaceProductGroupLinkRestOperations _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkRestClient;

        /// <summary> Initializes a new instance of the <see cref="ServiceWorkspaceProductGroupLinkCollection"/> class for mocking. </summary>
        protected ServiceWorkspaceProductGroupLinkCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ServiceWorkspaceProductGroupLinkCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ServiceWorkspaceProductGroupLinkCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApiManagement", ServiceWorkspaceProductGroupLinkResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ServiceWorkspaceProductGroupLinkResource.ResourceType, out string serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkApiVersion);
            _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkRestClient = new WorkspaceProductGroupLinkRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ServiceWorkspaceProductResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ServiceWorkspaceProductResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Adds a group to the specified product via link.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/products/{productId}/groupLinks/{groupLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceProductGroupLink_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceProductGroupLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="groupLinkId"> Product-Group link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="data"> Create or update parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="groupLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="groupLinkId"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ServiceWorkspaceProductGroupLinkResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string groupLinkId, ProductGroupLinkContractData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(groupLinkId, nameof(groupLinkId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkClientDiagnostics.CreateScope("ServiceWorkspaceProductGroupLinkCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, groupLinkId, data, cancellationToken).ConfigureAwait(false);
                var uri = _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, groupLinkId, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ApiManagementArmOperation<ServiceWorkspaceProductGroupLinkResource>(Response.FromValue(new ServiceWorkspaceProductGroupLinkResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Adds a group to the specified product via link.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/products/{productId}/groupLinks/{groupLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceProductGroupLink_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceProductGroupLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="groupLinkId"> Product-Group link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="data"> Create or update parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="groupLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="groupLinkId"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ServiceWorkspaceProductGroupLinkResource> CreateOrUpdate(WaitUntil waitUntil, string groupLinkId, ProductGroupLinkContractData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(groupLinkId, nameof(groupLinkId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkClientDiagnostics.CreateScope("ServiceWorkspaceProductGroupLinkCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, groupLinkId, data, cancellationToken);
                var uri = _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, groupLinkId, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ApiManagementArmOperation<ServiceWorkspaceProductGroupLinkResource>(Response.FromValue(new ServiceWorkspaceProductGroupLinkResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the group link for the product.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/products/{productId}/groupLinks/{groupLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceProductGroupLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceProductGroupLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="groupLinkId"> Product-Group link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="groupLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="groupLinkId"/> is null. </exception>
        public virtual async Task<Response<ServiceWorkspaceProductGroupLinkResource>> GetAsync(string groupLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(groupLinkId, nameof(groupLinkId));

            using var scope = _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkClientDiagnostics.CreateScope("ServiceWorkspaceProductGroupLinkCollection.Get");
            scope.Start();
            try
            {
                var response = await _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, groupLinkId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServiceWorkspaceProductGroupLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the group link for the product.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/products/{productId}/groupLinks/{groupLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceProductGroupLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceProductGroupLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="groupLinkId"> Product-Group link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="groupLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="groupLinkId"/> is null. </exception>
        public virtual Response<ServiceWorkspaceProductGroupLinkResource> Get(string groupLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(groupLinkId, nameof(groupLinkId));

            using var scope = _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkClientDiagnostics.CreateScope("ServiceWorkspaceProductGroupLinkCollection.Get");
            scope.Start();
            try
            {
                var response = _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, groupLinkId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServiceWorkspaceProductGroupLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists a collection of the group links associated with a product.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/products/{productId}/groupLinks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceProductGroupLink_ListByProduct</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceProductGroupLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> |     Field     |     Usage     |     Supported operators     |     Supported functions     |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| groupId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;. </param>
        /// <param name="top"> Number of records to return. </param>
        /// <param name="skip"> Number of records to skip. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ServiceWorkspaceProductGroupLinkResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ServiceWorkspaceProductGroupLinkResource> GetAllAsync(string filter = null, int? top = null, int? skip = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkRestClient.CreateListByProductRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, filter, top, skip);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkRestClient.CreateListByProductNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, filter, top, skip);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ServiceWorkspaceProductGroupLinkResource(Client, ProductGroupLinkContractData.DeserializeProductGroupLinkContractData(e)), _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkClientDiagnostics, Pipeline, "ServiceWorkspaceProductGroupLinkCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists a collection of the group links associated with a product.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/products/{productId}/groupLinks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceProductGroupLink_ListByProduct</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceProductGroupLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> |     Field     |     Usage     |     Supported operators     |     Supported functions     |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| groupId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;. </param>
        /// <param name="top"> Number of records to return. </param>
        /// <param name="skip"> Number of records to skip. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ServiceWorkspaceProductGroupLinkResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ServiceWorkspaceProductGroupLinkResource> GetAll(string filter = null, int? top = null, int? skip = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkRestClient.CreateListByProductRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, filter, top, skip);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkRestClient.CreateListByProductNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, filter, top, skip);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ServiceWorkspaceProductGroupLinkResource(Client, ProductGroupLinkContractData.DeserializeProductGroupLinkContractData(e)), _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkClientDiagnostics, Pipeline, "ServiceWorkspaceProductGroupLinkCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/products/{productId}/groupLinks/{groupLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceProductGroupLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceProductGroupLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="groupLinkId"> Product-Group link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="groupLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="groupLinkId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string groupLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(groupLinkId, nameof(groupLinkId));

            using var scope = _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkClientDiagnostics.CreateScope("ServiceWorkspaceProductGroupLinkCollection.Exists");
            scope.Start();
            try
            {
                var response = await _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, groupLinkId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/products/{productId}/groupLinks/{groupLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceProductGroupLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceProductGroupLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="groupLinkId"> Product-Group link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="groupLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="groupLinkId"/> is null. </exception>
        public virtual Response<bool> Exists(string groupLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(groupLinkId, nameof(groupLinkId));

            using var scope = _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkClientDiagnostics.CreateScope("ServiceWorkspaceProductGroupLinkCollection.Exists");
            scope.Start();
            try
            {
                var response = _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, groupLinkId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/products/{productId}/groupLinks/{groupLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceProductGroupLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceProductGroupLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="groupLinkId"> Product-Group link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="groupLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="groupLinkId"/> is null. </exception>
        public virtual async Task<NullableResponse<ServiceWorkspaceProductGroupLinkResource>> GetIfExistsAsync(string groupLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(groupLinkId, nameof(groupLinkId));

            using var scope = _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkClientDiagnostics.CreateScope("ServiceWorkspaceProductGroupLinkCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, groupLinkId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ServiceWorkspaceProductGroupLinkResource>(response.GetRawResponse());
                return Response.FromValue(new ServiceWorkspaceProductGroupLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/products/{productId}/groupLinks/{groupLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceProductGroupLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceProductGroupLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="groupLinkId"> Product-Group link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="groupLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="groupLinkId"/> is null. </exception>
        public virtual NullableResponse<ServiceWorkspaceProductGroupLinkResource> GetIfExists(string groupLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(groupLinkId, nameof(groupLinkId));

            using var scope = _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkClientDiagnostics.CreateScope("ServiceWorkspaceProductGroupLinkCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _serviceWorkspaceProductGroupLinkWorkspaceProductGroupLinkRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, groupLinkId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ServiceWorkspaceProductGroupLinkResource>(response.GetRawResponse());
                return Response.FromValue(new ServiceWorkspaceProductGroupLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ServiceWorkspaceProductGroupLinkResource> IEnumerable<ServiceWorkspaceProductGroupLinkResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ServiceWorkspaceProductGroupLinkResource> IAsyncEnumerable<ServiceWorkspaceProductGroupLinkResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
