// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.ApiManagement.Models;

namespace Azure.ResourceManager.ApiManagement
{
    /// <summary>
    /// A class representing a collection of <see cref="ServiceWorkspaceNamedValueResource"/> and their operations.
    /// Each <see cref="ServiceWorkspaceNamedValueResource"/> in the collection will belong to the same instance of <see cref="WorkspaceContractResource"/>.
    /// To get a <see cref="ServiceWorkspaceNamedValueCollection"/> instance call the GetServiceWorkspaceNamedValues method from an instance of <see cref="WorkspaceContractResource"/>.
    /// </summary>
    public partial class ServiceWorkspaceNamedValueCollection : ArmCollection, IEnumerable<ServiceWorkspaceNamedValueResource>, IAsyncEnumerable<ServiceWorkspaceNamedValueResource>
    {
        private readonly ClientDiagnostics _serviceWorkspaceNamedValueWorkspaceNamedValueClientDiagnostics;
        private readonly WorkspaceNamedValueRestOperations _serviceWorkspaceNamedValueWorkspaceNamedValueRestClient;

        /// <summary> Initializes a new instance of the <see cref="ServiceWorkspaceNamedValueCollection"/> class for mocking. </summary>
        protected ServiceWorkspaceNamedValueCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ServiceWorkspaceNamedValueCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ServiceWorkspaceNamedValueCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _serviceWorkspaceNamedValueWorkspaceNamedValueClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApiManagement", ServiceWorkspaceNamedValueResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ServiceWorkspaceNamedValueResource.ResourceType, out string serviceWorkspaceNamedValueWorkspaceNamedValueApiVersion);
            _serviceWorkspaceNamedValueWorkspaceNamedValueRestClient = new WorkspaceNamedValueRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, serviceWorkspaceNamedValueWorkspaceNamedValueApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != WorkspaceContractResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, WorkspaceContractResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates named value.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/namedValues/{namedValueId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceNamedValue_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceNamedValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="namedValueId"> Identifier of the NamedValue. </param>
        /// <param name="content"> Create parameters. </param>
        /// <param name="ifMatch"> ETag of the Entity. Not required when creating an entity, but required when updating an entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="namedValueId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="namedValueId"/> or <paramref name="content"/> is null. </exception>
        public virtual async Task<ArmOperation<ServiceWorkspaceNamedValueResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string namedValueId, ApiManagementNamedValueCreateOrUpdateContent content, ETag? ifMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(namedValueId, nameof(namedValueId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _serviceWorkspaceNamedValueWorkspaceNamedValueClientDiagnostics.CreateScope("ServiceWorkspaceNamedValueCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _serviceWorkspaceNamedValueWorkspaceNamedValueRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, namedValueId, content, ifMatch, cancellationToken).ConfigureAwait(false);
                var operation = new ApiManagementArmOperation<ServiceWorkspaceNamedValueResource>(new ServiceWorkspaceNamedValueOperationSource(Client), _serviceWorkspaceNamedValueWorkspaceNamedValueClientDiagnostics, Pipeline, _serviceWorkspaceNamedValueWorkspaceNamedValueRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, namedValueId, content, ifMatch).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates named value.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/namedValues/{namedValueId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceNamedValue_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceNamedValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="namedValueId"> Identifier of the NamedValue. </param>
        /// <param name="content"> Create parameters. </param>
        /// <param name="ifMatch"> ETag of the Entity. Not required when creating an entity, but required when updating an entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="namedValueId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="namedValueId"/> or <paramref name="content"/> is null. </exception>
        public virtual ArmOperation<ServiceWorkspaceNamedValueResource> CreateOrUpdate(WaitUntil waitUntil, string namedValueId, ApiManagementNamedValueCreateOrUpdateContent content, ETag? ifMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(namedValueId, nameof(namedValueId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _serviceWorkspaceNamedValueWorkspaceNamedValueClientDiagnostics.CreateScope("ServiceWorkspaceNamedValueCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _serviceWorkspaceNamedValueWorkspaceNamedValueRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, namedValueId, content, ifMatch, cancellationToken);
                var operation = new ApiManagementArmOperation<ServiceWorkspaceNamedValueResource>(new ServiceWorkspaceNamedValueOperationSource(Client), _serviceWorkspaceNamedValueWorkspaceNamedValueClientDiagnostics, Pipeline, _serviceWorkspaceNamedValueWorkspaceNamedValueRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, namedValueId, content, ifMatch).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the details of the named value specified by its identifier.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/namedValues/{namedValueId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceNamedValue_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceNamedValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="namedValueId"> Identifier of the NamedValue. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="namedValueId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="namedValueId"/> is null. </exception>
        public virtual async Task<Response<ServiceWorkspaceNamedValueResource>> GetAsync(string namedValueId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(namedValueId, nameof(namedValueId));

            using var scope = _serviceWorkspaceNamedValueWorkspaceNamedValueClientDiagnostics.CreateScope("ServiceWorkspaceNamedValueCollection.Get");
            scope.Start();
            try
            {
                var response = await _serviceWorkspaceNamedValueWorkspaceNamedValueRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, namedValueId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServiceWorkspaceNamedValueResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the details of the named value specified by its identifier.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/namedValues/{namedValueId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceNamedValue_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceNamedValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="namedValueId"> Identifier of the NamedValue. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="namedValueId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="namedValueId"/> is null. </exception>
        public virtual Response<ServiceWorkspaceNamedValueResource> Get(string namedValueId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(namedValueId, nameof(namedValueId));

            using var scope = _serviceWorkspaceNamedValueWorkspaceNamedValueClientDiagnostics.CreateScope("ServiceWorkspaceNamedValueCollection.Get");
            scope.Start();
            try
            {
                var response = _serviceWorkspaceNamedValueWorkspaceNamedValueRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, namedValueId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServiceWorkspaceNamedValueResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists a collection of named values defined within a workspace in a service instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/namedValues</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceNamedValue_ListByService</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceNamedValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> |     Field     |     Usage     |     Supported operators     |     Supported functions     |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| tags | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith, any, all |&lt;/br&gt;| displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;. </param>
        /// <param name="top"> Number of records to return. </param>
        /// <param name="skip"> Number of records to skip. </param>
        /// <param name="isKeyVaultRefreshFailed"> Query parameter to fetch named value entities based on refresh status. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ServiceWorkspaceNamedValueResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ServiceWorkspaceNamedValueResource> GetAllAsync(string filter = null, int? top = null, int? skip = null, KeyVaultRefreshState? isKeyVaultRefreshFailed = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _serviceWorkspaceNamedValueWorkspaceNamedValueRestClient.CreateListByServiceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, filter, top, skip, isKeyVaultRefreshFailed);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _serviceWorkspaceNamedValueWorkspaceNamedValueRestClient.CreateListByServiceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, filter, top, skip, isKeyVaultRefreshFailed);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ServiceWorkspaceNamedValueResource(Client, ApiManagementNamedValueData.DeserializeApiManagementNamedValueData(e)), _serviceWorkspaceNamedValueWorkspaceNamedValueClientDiagnostics, Pipeline, "ServiceWorkspaceNamedValueCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists a collection of named values defined within a workspace in a service instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/namedValues</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceNamedValue_ListByService</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceNamedValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> |     Field     |     Usage     |     Supported operators     |     Supported functions     |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| tags | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith, any, all |&lt;/br&gt;| displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;. </param>
        /// <param name="top"> Number of records to return. </param>
        /// <param name="skip"> Number of records to skip. </param>
        /// <param name="isKeyVaultRefreshFailed"> Query parameter to fetch named value entities based on refresh status. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ServiceWorkspaceNamedValueResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ServiceWorkspaceNamedValueResource> GetAll(string filter = null, int? top = null, int? skip = null, KeyVaultRefreshState? isKeyVaultRefreshFailed = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _serviceWorkspaceNamedValueWorkspaceNamedValueRestClient.CreateListByServiceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, filter, top, skip, isKeyVaultRefreshFailed);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _serviceWorkspaceNamedValueWorkspaceNamedValueRestClient.CreateListByServiceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, filter, top, skip, isKeyVaultRefreshFailed);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ServiceWorkspaceNamedValueResource(Client, ApiManagementNamedValueData.DeserializeApiManagementNamedValueData(e)), _serviceWorkspaceNamedValueWorkspaceNamedValueClientDiagnostics, Pipeline, "ServiceWorkspaceNamedValueCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/namedValues/{namedValueId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceNamedValue_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceNamedValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="namedValueId"> Identifier of the NamedValue. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="namedValueId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="namedValueId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string namedValueId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(namedValueId, nameof(namedValueId));

            using var scope = _serviceWorkspaceNamedValueWorkspaceNamedValueClientDiagnostics.CreateScope("ServiceWorkspaceNamedValueCollection.Exists");
            scope.Start();
            try
            {
                var response = await _serviceWorkspaceNamedValueWorkspaceNamedValueRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, namedValueId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/namedValues/{namedValueId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceNamedValue_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceNamedValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="namedValueId"> Identifier of the NamedValue. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="namedValueId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="namedValueId"/> is null. </exception>
        public virtual Response<bool> Exists(string namedValueId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(namedValueId, nameof(namedValueId));

            using var scope = _serviceWorkspaceNamedValueWorkspaceNamedValueClientDiagnostics.CreateScope("ServiceWorkspaceNamedValueCollection.Exists");
            scope.Start();
            try
            {
                var response = _serviceWorkspaceNamedValueWorkspaceNamedValueRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, namedValueId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/namedValues/{namedValueId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceNamedValue_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceNamedValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="namedValueId"> Identifier of the NamedValue. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="namedValueId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="namedValueId"/> is null. </exception>
        public virtual async Task<NullableResponse<ServiceWorkspaceNamedValueResource>> GetIfExistsAsync(string namedValueId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(namedValueId, nameof(namedValueId));

            using var scope = _serviceWorkspaceNamedValueWorkspaceNamedValueClientDiagnostics.CreateScope("ServiceWorkspaceNamedValueCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _serviceWorkspaceNamedValueWorkspaceNamedValueRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, namedValueId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ServiceWorkspaceNamedValueResource>(response.GetRawResponse());
                return Response.FromValue(new ServiceWorkspaceNamedValueResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/namedValues/{namedValueId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceNamedValue_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceWorkspaceNamedValueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="namedValueId"> Identifier of the NamedValue. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="namedValueId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="namedValueId"/> is null. </exception>
        public virtual NullableResponse<ServiceWorkspaceNamedValueResource> GetIfExists(string namedValueId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(namedValueId, nameof(namedValueId));

            using var scope = _serviceWorkspaceNamedValueWorkspaceNamedValueClientDiagnostics.CreateScope("ServiceWorkspaceNamedValueCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _serviceWorkspaceNamedValueWorkspaceNamedValueRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, namedValueId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ServiceWorkspaceNamedValueResource>(response.GetRawResponse());
                return Response.FromValue(new ServiceWorkspaceNamedValueResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ServiceWorkspaceNamedValueResource> IEnumerable<ServiceWorkspaceNamedValueResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ServiceWorkspaceNamedValueResource> IAsyncEnumerable<ServiceWorkspaceNamedValueResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
