// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.ApiManagement
{
    /// <summary>
    /// A class representing a collection of <see cref="ServiceTagProductLinkResource"/> and their operations.
    /// Each <see cref="ServiceTagProductLinkResource"/> in the collection will belong to the same instance of <see cref="ApiManagementTagResource"/>.
    /// To get a <see cref="ServiceTagProductLinkCollection"/> instance call the GetServiceTagProductLinks method from an instance of <see cref="ApiManagementTagResource"/>.
    /// </summary>
    public partial class ServiceTagProductLinkCollection : ArmCollection, IEnumerable<ServiceTagProductLinkResource>, IAsyncEnumerable<ServiceTagProductLinkResource>
    {
        private readonly ClientDiagnostics _serviceTagProductLinkTagProductLinkClientDiagnostics;
        private readonly TagProductLinkRestOperations _serviceTagProductLinkTagProductLinkRestClient;

        /// <summary> Initializes a new instance of the <see cref="ServiceTagProductLinkCollection"/> class for mocking. </summary>
        protected ServiceTagProductLinkCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ServiceTagProductLinkCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ServiceTagProductLinkCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _serviceTagProductLinkTagProductLinkClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApiManagement", ServiceTagProductLinkResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ServiceTagProductLinkResource.ResourceType, out string serviceTagProductLinkTagProductLinkApiVersion);
            _serviceTagProductLinkTagProductLinkRestClient = new TagProductLinkRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, serviceTagProductLinkTagProductLinkApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ApiManagementTagResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ApiManagementTagResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Adds a product to the specified tag via link.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}/productLinks/{productLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TagProductLink_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="productLinkId"> Tag-product link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="data"> Create or update parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productLinkId"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ServiceTagProductLinkResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string productLinkId, TagProductLinkContractData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productLinkId, nameof(productLinkId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _serviceTagProductLinkTagProductLinkClientDiagnostics.CreateScope("ServiceTagProductLinkCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _serviceTagProductLinkTagProductLinkRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, productLinkId, data, cancellationToken).ConfigureAwait(false);
                var uri = _serviceTagProductLinkTagProductLinkRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, productLinkId, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ApiManagementArmOperation<ServiceTagProductLinkResource>(Response.FromValue(new ServiceTagProductLinkResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Adds a product to the specified tag via link.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}/productLinks/{productLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TagProductLink_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="productLinkId"> Tag-product link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="data"> Create or update parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productLinkId"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ServiceTagProductLinkResource> CreateOrUpdate(WaitUntil waitUntil, string productLinkId, TagProductLinkContractData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productLinkId, nameof(productLinkId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _serviceTagProductLinkTagProductLinkClientDiagnostics.CreateScope("ServiceTagProductLinkCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _serviceTagProductLinkTagProductLinkRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, productLinkId, data, cancellationToken);
                var uri = _serviceTagProductLinkTagProductLinkRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, productLinkId, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ApiManagementArmOperation<ServiceTagProductLinkResource>(Response.FromValue(new ServiceTagProductLinkResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the product link for the tag.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}/productLinks/{productLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TagProductLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productLinkId"> Tag-product link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productLinkId"/> is null. </exception>
        public virtual async Task<Response<ServiceTagProductLinkResource>> GetAsync(string productLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productLinkId, nameof(productLinkId));

            using var scope = _serviceTagProductLinkTagProductLinkClientDiagnostics.CreateScope("ServiceTagProductLinkCollection.Get");
            scope.Start();
            try
            {
                var response = await _serviceTagProductLinkTagProductLinkRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, productLinkId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServiceTagProductLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the product link for the tag.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}/productLinks/{productLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TagProductLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productLinkId"> Tag-product link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productLinkId"/> is null. </exception>
        public virtual Response<ServiceTagProductLinkResource> Get(string productLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productLinkId, nameof(productLinkId));

            using var scope = _serviceTagProductLinkTagProductLinkClientDiagnostics.CreateScope("ServiceTagProductLinkCollection.Get");
            scope.Start();
            try
            {
                var response = _serviceTagProductLinkTagProductLinkRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, productLinkId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServiceTagProductLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists a collection of the product links associated with a tag.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}/productLinks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TagProductLink_ListByProduct</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> |     Field     |     Usage     |     Supported operators     |     Supported functions     |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| productId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;. </param>
        /// <param name="top"> Number of records to return. </param>
        /// <param name="skip"> Number of records to skip. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ServiceTagProductLinkResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ServiceTagProductLinkResource> GetAllAsync(string filter = null, int? top = null, int? skip = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _serviceTagProductLinkTagProductLinkRestClient.CreateListByProductRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, filter, top, skip);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _serviceTagProductLinkTagProductLinkRestClient.CreateListByProductNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, filter, top, skip);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ServiceTagProductLinkResource(Client, TagProductLinkContractData.DeserializeTagProductLinkContractData(e)), _serviceTagProductLinkTagProductLinkClientDiagnostics, Pipeline, "ServiceTagProductLinkCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists a collection of the product links associated with a tag.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}/productLinks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TagProductLink_ListByProduct</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> |     Field     |     Usage     |     Supported operators     |     Supported functions     |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| productId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;. </param>
        /// <param name="top"> Number of records to return. </param>
        /// <param name="skip"> Number of records to skip. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ServiceTagProductLinkResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ServiceTagProductLinkResource> GetAll(string filter = null, int? top = null, int? skip = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _serviceTagProductLinkTagProductLinkRestClient.CreateListByProductRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, filter, top, skip);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _serviceTagProductLinkTagProductLinkRestClient.CreateListByProductNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, filter, top, skip);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ServiceTagProductLinkResource(Client, TagProductLinkContractData.DeserializeTagProductLinkContractData(e)), _serviceTagProductLinkTagProductLinkClientDiagnostics, Pipeline, "ServiceTagProductLinkCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}/productLinks/{productLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TagProductLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productLinkId"> Tag-product link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productLinkId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string productLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productLinkId, nameof(productLinkId));

            using var scope = _serviceTagProductLinkTagProductLinkClientDiagnostics.CreateScope("ServiceTagProductLinkCollection.Exists");
            scope.Start();
            try
            {
                var response = await _serviceTagProductLinkTagProductLinkRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, productLinkId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}/productLinks/{productLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TagProductLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productLinkId"> Tag-product link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productLinkId"/> is null. </exception>
        public virtual Response<bool> Exists(string productLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productLinkId, nameof(productLinkId));

            using var scope = _serviceTagProductLinkTagProductLinkClientDiagnostics.CreateScope("ServiceTagProductLinkCollection.Exists");
            scope.Start();
            try
            {
                var response = _serviceTagProductLinkTagProductLinkRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, productLinkId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}/productLinks/{productLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TagProductLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productLinkId"> Tag-product link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productLinkId"/> is null. </exception>
        public virtual async Task<NullableResponse<ServiceTagProductLinkResource>> GetIfExistsAsync(string productLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productLinkId, nameof(productLinkId));

            using var scope = _serviceTagProductLinkTagProductLinkClientDiagnostics.CreateScope("ServiceTagProductLinkCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _serviceTagProductLinkTagProductLinkRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, productLinkId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ServiceTagProductLinkResource>(response.GetRawResponse());
                return Response.FromValue(new ServiceTagProductLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}/productLinks/{productLinkId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TagProductLink_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceTagProductLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="productLinkId"> Tag-product link identifier. Must be unique in the current API Management service instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="productLinkId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="productLinkId"/> is null. </exception>
        public virtual NullableResponse<ServiceTagProductLinkResource> GetIfExists(string productLinkId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(productLinkId, nameof(productLinkId));

            using var scope = _serviceTagProductLinkTagProductLinkClientDiagnostics.CreateScope("ServiceTagProductLinkCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _serviceTagProductLinkTagProductLinkRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, productLinkId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ServiceTagProductLinkResource>(response.GetRawResponse());
                return Response.FromValue(new ServiceTagProductLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ServiceTagProductLinkResource> IEnumerable<ServiceTagProductLinkResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ServiceTagProductLinkResource> IAsyncEnumerable<ServiceTagProductLinkResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
