// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Configuration of a virtual network to which API Management service is deployed. </summary>
    public partial class VirtualNetworkConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VirtualNetworkConfiguration"/>. </summary>
        public VirtualNetworkConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VirtualNetworkConfiguration"/>. </summary>
        /// <param name="vnetId"> The virtual network ID. This is typically a GUID. Expect a null GUID by default. </param>
        /// <param name="subnetname"> The name of the subnet. </param>
        /// <param name="subnetResourceId"> The full resource ID of a subnet in a virtual network to deploy the API Management service in. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VirtualNetworkConfiguration(Guid? vnetId, string subnetname, ResourceIdentifier subnetResourceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VnetId = vnetId;
            Subnetname = subnetname;
            SubnetResourceId = subnetResourceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The virtual network ID. This is typically a GUID. Expect a null GUID by default. </summary>
        [WirePath("vnetid")]
        public Guid? VnetId { get; }
        /// <summary> The name of the subnet. </summary>
        [WirePath("subnetname")]
        public string Subnetname { get; }
        /// <summary> The full resource ID of a subnet in a virtual network to deploy the API Management service in. </summary>
        [WirePath("subnetResourceId")]
        public ResourceIdentifier SubnetResourceId { get; set; }
    }
}
